/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import de.qfm.erp.common.response.search.SearchResponse;
import de.qfm.erp.service.service.route.SearchV2Route;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(description="Search V2 Management Resource", name="SearchV2Resource")
@OpenAPIDefinition(tags={@Tag(name="StagePropagationResource", description="All Operations around Search V2")})
@ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully retrieved Entity / List", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="401", description="You are not authorized to view the resource", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="403", description="Accessing the resource you were trying to reach is forbidden", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="The resource you were trying to reach is not found", content={@Content(mediaType="application/json")})})
@RestController
@RequestMapping(value={"/api/v2/erp/search"})
public class SearchResource {
    private static final Logger log = LogManager.getLogger(SearchResource.class);
    private static final Splitter COMMA_SPLITTER = Splitter.on((String)",").trimResults().omitEmptyStrings();
    private SearchV2Route route;

    @Operation(summary="Global AutoComplete", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=SearchResponse.class))})})
    @GetMapping(value={"/_autocomplete/"}, produces={"application/json"})
    public SearchResponse autocomplete(@RequestParam(value="q") String query, @RequestParam(value="size", defaultValue="3") int size, @Parameter(description="include archived items in search (e.g. stage.state==archived)", example="true,false,null") @RequestParam(value="flag_include_archived", defaultValue="false") boolean includeArchived, @Parameter(description="executes search for the given domains, comma separated", example="INVOICE,PSX_RELEASE_ORDER", schema=@Schema(description="executes search for the given domains, comma separated", allowableValues={"INVOICE,USER,MEASUREMENT,CUSTOMER,STAGE,SUB_PROJECT,PSX_CONSTRUCTION_SITE,PSX_RELEASE_ORDER"})) @RequestParam(value="entity_types", defaultValue="INVOICE,USER,MEASUREMENT,CUSTOMER,ENTITY,STAGE,SUB_PROJECT,PSX_CONSTRUCTION_SITE,PSX_RELEASE_ORDER") String entityTypesTxt) {
        List entityTypesCandidates = COMMA_SPLITTER.splitToList((CharSequence)StringUtils.trimToEmpty((String)entityTypesTxt));
        return this.route.search(query, size, ((Boolean)MoreObjects.firstNonNull((Object)includeArchived, (Object)false)).booleanValue(), (Iterable)entityTypesCandidates);
    }

    public SearchResource(SearchV2Route route) {
        this.route = route;
    }
}

