/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import de.qfm.erp.common.response.measurement.ReleaseOrdersCommonV1;
import de.qfm.erp.service.service.route.ReleaseOrderRoute;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(description="Release Order Resource", name="ReleaseOrderResource")
@OpenAPIDefinition(tags={@Tag(name="ReleaseOrderResource", description="All Operations around Release Orders")})
@ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully retrieved Entity / List", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="401", description="You are not authorized to view the resource", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="403", description="Accessing the resource you were trying to reach is forbidden", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="The resource you were trying to reach is not found", content={@Content(mediaType="application/json")})})
@RestController
@RequestMapping(value={"/api/v1/erp/releaseorders"})
public class ReleaseOrderResourceV1 {
    private static final Logger log = LogManager.getLogger(ReleaseOrderResourceV1.class);
    private final ReleaseOrderRoute releaseOrderRoute;

    @Operation(summary="Release Order Page for Quotation and Squad", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ReleaseOrdersCommonV1.class))})})
    @GetMapping(value={"/"})
    public ReleaseOrdersCommonV1 list(@Parameter(description="The Quotation Id applied as a Filter to Release Orders", example="null") @RequestParam(value="filter_quotation_id", required=false) Long quotationId, @Parameter(description="The User Id applied as a Filter to Release Orders", example="null") @RequestParam(value="filter_user_id", required=false) Long userId, @Parameter(description="The Page index starting at 0", example="0") @RequestParam(value="page", defaultValue="0") int page, @Parameter(description="The Page Size", example="100") @RequestParam(value="size", defaultValue="100") int size) {
        return this.releaseOrderRoute.listByQuotationAndSquad(quotationId, userId, page, size);
    }

    public ReleaseOrderResourceV1(ReleaseOrderRoute releaseOrderRoute) {
        this.releaseOrderRoute = releaseOrderRoute;
    }
}

