/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import de.qfm.erp.common.response.psx.PsxConstructionSiteCommon;
import de.qfm.erp.common.response.psx.PsxEntryListCommon;
import de.qfm.erp.common.response.psx.PsxOrderValueListCommon;
import de.qfm.erp.common.response.psx.PsxReleaseOrderCommon;
import de.qfm.erp.common.response.psx.PsxSaveAllResponse;
import de.qfm.erp.common.response.psx.PsxWorkSpaceListCommon;
import de.qfm.erp.service.service.route.PsxRoute;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(description="PSX Management Resource", name="PsxResource")
@OpenAPIDefinition(tags={@Tag(name="PsxResource", description="All Operations around PSX")})
@ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully retrieved Entity / List", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="401", description="You are not authorized to view the resource", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="403", description="Accessing the resource you were trying to reach is forbidden", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="The resource you were trying to reach is not found", content={@Content(mediaType="application/json")})})
@RestController
@RequestMapping(value={"/api/v1/erp/psx"})
public class PsxResource {
    private static final Logger log = LogManager.getLogger(PsxResource.class);
    private final PsxRoute route;

    @Schema(description="PSX Release Order List / Paging", implementation=PsxEntryListCommon.class)
    @GetMapping(value={"/entries/"})
    public PsxEntryListCommon list(@Parameter(description="Stage Id") @RequestParam(value="filter_stage_id", defaultValue="") Long filterStageId, @Parameter(description="Filter by 'any' Text", example="") @RequestParam(value="filter_text", defaultValue="") String filterText) {
        return this.route.entries(filterStageId, filterText);
    }

    @Schema(description="PSX Construction Site by ReferenceId", implementation=PsxConstructionSiteCommon.class)
    @GetMapping(value={"/constructionsites/{reference_id}/"})
    public PsxConstructionSiteCommon constructionSiteByReferenceId(@PathVariable(value="reference_id") String referenceID) {
        return this.route.constructionSiteByReferenceId(referenceID);
    }

    @Schema(description="PSX Release Order by ReferenceId", implementation=PsxReleaseOrderCommon.class)
    @GetMapping(value={"/releaseorders/{reference_id}/"})
    public PsxReleaseOrderCommon roById(@PathVariable(value="reference_id") String referenceID) {
        return this.route.releaseOrderByReferenceId(referenceID);
    }

    @Schema(description="PSX Release Order List / Paging", implementation=PsxOrderValueListCommon.class)
    @GetMapping(value={"/order_values/stage_id={stage_id}/"})
    public PsxOrderValueListCommon list(@Parameter(description="Stage Id", required=true) @PathVariable(value="stage_id") Long stageId) {
        return this.route.orderValues(stageId);
    }

    @Schema(description="PSX Workspaces List", implementation=PsxWorkSpaceListCommon.class)
    @GetMapping(value={"/workspaces/"})
    public PsxWorkSpaceListCommon list() {
        return this.route.psxWorkSpaces();
    }

    @Schema(description="PSX Workspaces List", implementation=PsxSaveAllResponse.class)
    @PostMapping(value={"/stage_id={stage_id}/_create_ro_and_cs/"})
    public PsxSaveAllResponse createAllByStageId(@PathVariable(value="stage_id") Long stageId) {
        return this.route.createAllByStageId(stageId);
    }

    public PsxResource(PsxRoute route) {
        this.route = route;
    }
}

