/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import com.google.common.collect.ImmutableList;
import de.qfm.erp.common.request.employee.attendance.AttendanceListUpdateRequest;
import de.qfm.erp.common.request.employee.payroll.PayrollMonthBatchPrintRequest;
import de.qfm.erp.common.request.employee.payroll.PayrollMonthSBSBatchExportRequest;
import de.qfm.erp.common.request.employee.payroll.PayrollMonthUpdateRequest;
import de.qfm.erp.common.response.employee.attendance.AttendanceCommon;
import de.qfm.erp.common.response.employee.attendance.AttendancesListCommon;
import de.qfm.erp.common.response.employee.payroll.PayrollMonthAutocompleteItemListCommon;
import de.qfm.erp.common.response.employee.payroll.PayrollMonthCommon;
import de.qfm.erp.common.response.employee.payroll.PayrollMonthItemListCommon;
import de.qfm.erp.common.response.employee.payroll.PayrollMonthPageCommon;
import de.qfm.erp.common.response.employee.payroll.WagesAssignedToPayrollCommon;
import de.qfm.erp.common.response.employee.wagedistribution.StageWageListCommon;
import de.qfm.erp.common.response.generic.PayrollItemTypePageCommon;
import de.qfm.erp.common.response.user.UserAutoCompleteResponse;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceOrigin;
import de.qfm.erp.service.resource.AbstractResource;
import de.qfm.erp.service.service.route.AutoCompleteRoute;
import de.qfm.erp.service.service.route.PayrollMonthRoute;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.io.IOException;
import java.time.LocalDate;
import java.time.YearMonth;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@Tag(description="Payroll Month Resource", name="PayrollMonthResource")
@OpenAPIDefinition(tags={@Tag(name="PayrollMonthResource", description="All Operations around Payroll Months")})
@ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully retrieved Entity / List", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="401", description="You are not authorized to view the resource", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="403", description="Accessing the resource you were trying to reach is forbidden", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="The resource you were trying to reach is not found", content={@Content(mediaType="application/json")})})
@RestController
@RequestMapping(value={"/api/v1/erp/payroll_months"})
public class PayrollMonthResource
extends AbstractResource {
    private static final Logger log = LogManager.getLogger(PayrollMonthResource.class);
    private final AutoCompleteRoute autoCompleteRoute;
    private final PayrollMonthRoute payrollMonthRoute;

    @Operation(summary="Payroll Month List for the given Filters")
    @GetMapping(value={"/"}, produces={"application/json"})
    public PayrollMonthPageCommon list(@Parameter(description="Accounting Month in (including day - 1st of month)", example="ISO Date Format yyyy-MM-dd") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) @RequestParam(value="accounting_month", defaultValue="") LocalDate accountingMonth, @Parameter(description="Cost Center") @RequestParam(value="cost_center", defaultValue="") String costCenter, @RequestParam(value="page", defaultValue="0") int page, @RequestParam(value="size", defaultValue="100") int size, @RequestParam(value="include_statistics", defaultValue="false") boolean includeStatistics, @RequestParam(value="include_inactive", defaultValue="false") boolean includeInactive, @RequestParam(value="include_temporary", defaultValue="false") boolean includeTemporary) {
        return this.payrollMonthRoute.page(accountingMonth, StringUtils.trimToEmpty((String)costCenter), page, size, includeStatistics, includeInactive, includeTemporary);
    }

    @Operation(summary="Payroll Month Information for a defined Personal Number, Year and Month")
    @GetMapping(value={"/user_id={userId}/{year}/{month}/"}, produces={"application/json"})
    public PayrollMonthCommon byUserIdAndYearAndMonth(@PathVariable(value="userId") long userId, @PathVariable(value="year") int year, @PathVariable(value="month") int month) {
        return this.payrollMonthRoute.byUserIdAndYearAndMonth(EAttendanceOrigin.PAYROLL_MONTH, userId, year, month);
    }

    @Operation(summary="Persist Payroll Month by Id")
    @PostMapping(value={"/{id}/"}, consumes={"application/json"}, produces={"application/json"})
    public PayrollMonthCommon update(@PathVariable(value="id") long id, @RequestBody @Valid PayrollMonthUpdateRequest request) {
        return this.payrollMonthRoute.update(id, request);
    }

    @Operation(summary="Payroll Month specific User AutoComplete")
    @GetMapping(value={"/{id}/_autocomplete/"})
    public UserAutoCompleteResponse autocomplete(@PathVariable(value="id") long payrollMonthId, @Parameter(description="Filter by 'any' Text", example="") @RequestParam(value="filter_text", defaultValue="") String filterText) {
        return this.autoCompleteRoute.payrollMonthAutoComplete(payrollMonthId, filterText);
    }

    @Operation(summary="Print Payroll Month Id")
    @GetMapping(value={"/{id}/_print/"}, produces={"application/json"})
    public void printId(@Parameter(description="Payroll Month Id from of the Payroll Month to Print", required=true) @PathVariable(value="id") long id, @Parameter(description="Printing Template", example="[PAYSLIP, REPORT, ATTENDANCE]", required=true) @RequestParam(value="print_template", defaultValue="PAYSLIP", required=true) String printTemplate, HttpServletResponse response) throws IOException {
        Pair pdfContent = this.payrollMonthRoute.printPayrollMonth(id, printTemplate);
        PayrollMonthResource.writeToStream((HttpServletResponse)response, (Pair)pdfContent, (String)"application/pdf");
    }

    @Operation(summary="Print File(s) into ZIP by Payroll Month Ids")
    @PostMapping(value={"/_print/zip/"}, consumes={"application/json"}, produces={"application/zip"})
    public void printPayrollMonthsIntoZIP(@Parameter(description="Payroll Month Ids and Template to be printed") @Valid @RequestBody PayrollMonthBatchPrintRequest batchPrintRequest, HttpServletResponse response) throws IOException {
        Pair content = this.payrollMonthRoute.printPayrollMonthsAsZIP((Iterable)batchPrintRequest.getPayrollMonthIds(), batchPrintRequest.getTemplate());
        PayrollMonthResource.writeToStream((HttpServletResponse)response, (Pair)content, (String)"application/octet-stream");
    }

    @Operation(summary="Print File(s) into ONE PDF by Payroll Month Ids")
    @PostMapping(value={"/_print/pdf/"}, consumes={"application/json"}, produces={"application/pdf"})
    public void printPayrollMonthsIntoPDF(@Parameter(description="Payroll Month Ids and Template to be printed") @Valid @RequestBody PayrollMonthBatchPrintRequest batchPrintRequest, HttpServletResponse response) throws IOException {
        Pair content = this.payrollMonthRoute.printPayrollMonthsAsPDF((Iterable)batchPrintRequest.getPayrollMonthIds(), batchPrintRequest.getTemplate());
        PayrollMonthResource.writeToStream((HttpServletResponse)response, (Pair)content);
    }

    @Operation(summary="Print File(s) into ONE PDF by Payroll Month Ids")
    @GetMapping(value={"/_print/pdf/"}, produces={"application/pdf"})
    public void printPayrollMonthsIntoPDF(@Parameter(description="Printing Template", example="[PAYSLIP]", required=true) @RequestParam(value="print_template", defaultValue="PAYSLIP") String printTemplate, @Parameter(description="Comma separated List of IDs") @RequestParam(value="ids", defaultValue="") String ids, HttpServletResponse response) throws IOException {
        Pair content = this.payrollMonthRoute.printPayrollMonthsAsPDF(ids, printTemplate);
        PayrollMonthResource.writeToStream((HttpServletResponse)response, (Pair)content);
    }

    @Operation(summary="Print Attendance Aggregation for Business Unit")
    @GetMapping(value={"/cost_center={costCenter}/{year}/{month}/_print/"}, produces={"application/json"})
    public void printCostCenter(@Parameter(description="Cost Center", required=true) @PathVariable(value="costCenter") String costCenter, @Parameter(description="Printing Template", example="[ATTENDANCE]", required=true) @RequestParam(value="print_template", defaultValue="ATTENDANCE", required=true) String printTemplate, @PathVariable(value="year") int year, @PathVariable(value="month") int month, HttpServletResponse response) throws IOException {
        Pair pdfContent = this.payrollMonthRoute.printByCostCenter(costCenter, printTemplate, year, month);
        PayrollMonthResource.writeToStream((HttpServletResponse)response, (Pair)pdfContent, (String)"application/pdf");
    }

    @Operation(summary="Release Payroll Month for Id")
    @PostMapping(value={"/{id}/_release/"}, consumes={"application/json"}, produces={"application/json"})
    public PayrollMonthCommon release(@Parameter(description="Payroll Month Id from of the Payroll Month to be Released", required=true) @PathVariable(value="id") long id) throws IOException {
        return this.payrollMonthRoute.release(id);
    }

    @Operation(summary="Unrelease Payroll Month for Id")
    @PostMapping(value={"/{id}/_unrelease/"}, consumes={"application/json"}, produces={"application/json"})
    public PayrollMonthCommon unrelease(@Parameter(description="Payroll Month Id from of the Payroll Month to be Unreleased", required=true) @PathVariable(value="id") long id) throws IOException {
        return this.payrollMonthRoute.unrelease(id);
    }

    @Operation(summary="Reset Payroll Month for Id")
    @PostMapping(value={"/{id}/_reset/"}, produces={"application/json"})
    public PayrollMonthCommon reset(@Parameter(description="Payroll Month Id from of the Payroll Month to be Released", required=true) @PathVariable(value="id") long id) throws IOException {
        return this.payrollMonthRoute.reset(id);
    }

    @Operation(summary="Export File for SBS by Payroll Month Id (DEPRECATED, use POST API)")
    @GetMapping(value={"/{id}/_sbs_export/"}, produces={"application/json"})
    @Deprecated
    public void exportToSBS(@Parameter(description="Payroll Month Id from of the Payroll Month to Print", required=true) @PathVariable(value="id") long id, HttpServletResponse response) throws IOException {
        Pair content = this.payrollMonthRoute.exportToSBS((Iterable)ImmutableList.of((Object)id));
        PayrollMonthResource.writeToStream((HttpServletResponse)response, (Pair)content);
    }

    @Operation(summary="Export File for SBS by Payroll Month Ids")
    @PostMapping(value={"/_sbs_export/"}, consumes={"application/json"}, produces={"application/json"})
    public void exportToSBS(@Parameter(description="Payroll Month Ids to be exported") @Valid @RequestBody PayrollMonthSBSBatchExportRequest payrollMonthSBSBatchExportRequest, HttpServletResponse response) throws IOException {
        Pair content = this.payrollMonthRoute.exportToSBS((Iterable)payrollMonthSBSBatchExportRequest.getPayrollMonthIds());
        PayrollMonthResource.writeToStream((HttpServletResponse)response, (Pair)content);
    }

    @Operation(summary="Attendance by Id")
    @GetMapping(value={"/attendances/{id}/"}, produces={"application/json"})
    public AttendanceCommon getById(@PathVariable(value="id") long id) {
        return this.payrollMonthRoute.attendanceById(id);
    }

    @Operation(summary="Monthly Attendances for a defined Personal Number, Year and Month")
    @GetMapping(value={"/user_id={userId}/{year}/{month}/attendances/"}, produces={"application/json"})
    public AttendancesListCommon attendancesByUserIdAndYearAndMonth(@PathVariable(value="userId") long userId, @PathVariable(value="year") int year, @PathVariable(value="month") int month) {
        return this.payrollMonthRoute.attendancesByUserIdAndYearAndMonth(EAttendanceOrigin.PAYROLL_MONTH, userId, year, month);
    }

    @Operation(summary="Monthly Attendances for a defined PayrollMonth.Id")
    @GetMapping(value={"/{id}/attendances/"}, produces={"application/json"})
    public AttendancesListCommon attendancesById(@PathVariable(value="id") long id) {
        return this.payrollMonthRoute.attendancesById(id);
    }

    @Operation(summary="Candidates for PayrollMonth with Bad Weather Data")
    @GetMapping(value={"/user_id={userId}/{year}/{month}/_bad_weather_candidates_autocomplete/"})
    public PayrollMonthAutocompleteItemListCommon autocomplete(@PathVariable(value="userId") long userId, @PathVariable(value="year") int year, @PathVariable(value="month") int month, @Parameter(description="Filter by 'any' Text", example="") @RequestParam(value="filter_text", defaultValue="") String filterText) {
        return this.payrollMonthRoute.badWeatherCandidateAutocomplete(userId, year, month, filterText);
    }

    @Operation(summary="Batch Update of Attendances")
    @PostMapping(value={"/attendances/"}, consumes={"application/json"}, produces={"application/json"})
    public AttendancesListCommon save(@Parameter(description="An Attendance List Update Request Object", required=true) @Valid @RequestBody AttendanceListUpdateRequest attendanceListUpdateRequest) {
        return this.payrollMonthRoute.update(attendanceListUpdateRequest);
    }

    @Operation(summary="List All (current) Quotation Wages")
    @GetMapping(value={"/{id}/quotation_wages/"}, produces={"application/json"})
    public StageWageListCommon listQuotationWages(@PathVariable(value="id") long id, @Parameter(name="operation", description="le = less or equal to payroll month, eq = exact payroll month, all = no filter", example="[le, eq, all]") @RequestParam(name="operation", defaultValue="le", required=false) String operation, @RequestParam(name="hide_zero", defaultValue="true", required=false) boolean hideZero) {
        return this.payrollMonthRoute.listQuotationWages(id, operation, hideZero);
    }

    @Operation(summary="List All (current) Quotation Wages based upon User / Payroll Month")
    @GetMapping(value={"/user_id={userId}/{year}/{month}/quotation_wages/"}, produces={"application/json"})
    public StageWageListCommon listQuotationWages(@PathVariable(value="userId") long userId, @PathVariable(value="year") int year, @PathVariable(value="month") int month, @Parameter(name="operation", description="le = less or equal to payroll month, eq = exact payroll month, all = no filter", example="[le, eq, all]") @RequestParam(name="operation", defaultValue="le", required=false) String operation, @RequestParam(name="hide_zero", defaultValue="true", required=false) boolean hideZero) {
        return this.payrollMonthRoute.listQuotationWages(EAttendanceOrigin.PAYROLL_MONTH, userId, year, month, operation, hideZero);
    }

    @Operation(summary="PayrollItemType List / Paging")
    @GetMapping(value={"/{id}/available_payroll_item_types/"}, produces={"application/json"})
    public PayrollItemTypePageCommon list(@RequestParam(value="page", defaultValue="0") int page, @RequestParam(value="size", defaultValue="100") int size, @RequestParam(value="all", defaultValue="false") boolean all, @PathVariable(value="id") long payrollMonthId) {
        return this.payrollMonthRoute.availablePayrollItemTypes(page, size, all, payrollMonthId);
    }

    @Deprecated
    @Operation(summary="List all (current) Payroll Items assigned to payroll")
    @GetMapping(value={"/{id}/incentive_wages_assigned_to_payroll/"}, produces={"application/json"})
    public PayrollMonthItemListCommon incentiveWagesAssignedToPayroll(@PathVariable(value="id") long id) {
        return this.payrollMonthRoute.incentiveWagesAssignedToPayroll(id);
    }

    @Operation(summary="List all (current) Payroll Items assigned to payroll")
    @GetMapping(value={"/{id}/wages_assigned_to_payroll/"}, produces={"application/json"})
    public WagesAssignedToPayrollCommon wagesAssignedToPayroll(@PathVariable(value="id") long id) {
        return this.payrollMonthRoute.wagesAssignedToPayroll(id);
    }

    @Operation(summary="Export File for Wages by Month")
    @GetMapping(value={"/{year}/{month}/_xls/"}, produces={"application/json"})
    public void exportWagesAsXLL(@Parameter(description="Year of the Export", required=true) @PathVariable(value="year") int year, @Parameter(description="Month of the Export", required=true) @PathVariable(value="month") int month, HttpServletResponse response) throws IOException {
        YearMonth yearMonth = YearMonth.of(year, month);
        Pair content = this.payrollMonthRoute.exportWagesAsXLS(yearMonth);
        PayrollMonthResource.writeToStream((HttpServletResponse)response, (Pair)content);
    }

    @Operation(summary="Export File for Project Based Wage Export by CC and Month")
    @GetMapping(value={"/{year}/{month}/{cost_center}/project_based_wage_export/_xls/"}, produces={"application/json"})
    public void projectBasedWageExportAsXLS(@Parameter(description="Year of the Export", required=true) @PathVariable(value="year") int year, @Parameter(description="Month of the Export", required=true) @PathVariable(value="month") int month, @Parameter(description="Filter by Cost Center", required=true) @PathVariable(value="cost_center") String costCenterParam, HttpServletResponse response) throws IOException {
        YearMonth yearMonth = YearMonth.of(year, month);
        String costCenter = StringUtils.trimToEmpty((String)costCenterParam);
        Pair content = this.payrollMonthRoute.projectBasedWageExportAsXLS(yearMonth, costCenter);
        PayrollMonthResource.writeToStream((HttpServletResponse)response, (Pair)content);
    }

    private static void writeToStream(@NonNull HttpServletResponse response, @NonNull Pair<String, byte[]> content) throws IOException {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        ServletOutputStream outputStream = response.getOutputStream();
        String name = (String)content.getLeft();
        byte[] contents = (byte[])content.getRight();
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("inline; filename=%s", name));
        response.setContentLength(contents.length);
        outputStream.write(contents);
        outputStream.flush();
        outputStream.close();
    }

    public PayrollMonthResource(AutoCompleteRoute autoCompleteRoute, PayrollMonthRoute payrollMonthRoute) {
        this.autoCompleteRoute = autoCompleteRoute;
        this.payrollMonthRoute = payrollMonthRoute;
    }
}

