/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import de.qfm.erp.common.response.history.v1.HistoryItemCommon;
import de.qfm.erp.common.response.history.v1.HistoryItemPageCommon;
import de.qfm.erp.service.service.route.HistoryItemRoute;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.SwaggerDefinition;
import io.swagger.annotations.Tag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="History Resource", tags={"HistoryResource"})
@SwaggerDefinition(tags={@Tag(name="HistoryResource", description="All Operations around History")})
@RestController
@RequestMapping(value={"/api/v2/erp/history"})
public class HistoryResourceV2 {
    private static final Logger log = LogManager.getLogger(HistoryResourceV2.class);
    private final HistoryItemRoute route;

    @ApiOperation(value="HistoryItem List / Paging")
    @GetMapping(value={"/"})
    public HistoryItemPageCommon list(@RequestParam(value="page", defaultValue="0") int page, @RequestParam(value="size", defaultValue="100") int size) {
        return this.route.page(page, size);
    }

    @ApiOperation(value="HistoryItem for Id")
    @GetMapping(value={"/{id}/"})
    public HistoryItemCommon getById(@PathVariable(value="id") long id) {
        return this.route.byId(id);
    }

    @ApiOperation(value="Paged HistoryItems for Class and EntityId, sorted by Creation Date Descending")
    @GetMapping(value={"/{entity_clazz}/{entity_id}/"}, produces={"application/json"})
    public HistoryItemPageCommon getByClassAndId(@ApiParam(allowableValues="MEASUREMENT", value="The Entity Class of the Required History", required=true) @PathVariable(value="entity_clazz") String entityClazzCandidate, @ApiParam(value="The Entity Id of the Required History", required=true) @PathVariable(value="entity_id") long entityId, @ApiParam(value="The Page index starting at 0", defaultValue="0") @RequestParam(value="page", defaultValue="0") int page, @ApiParam(value="The Page Size", defaultValue="100") @RequestParam(value="size", defaultValue="100") int size) {
        return this.route.pageForEntity(entityClazzCandidate, entityId, page, size);
    }

    @Autowired
    public HistoryResourceV2(HistoryItemRoute route) {
        this.route = route;
    }
}

