/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import de.qfm.erp.common.response.entityusage.EntityUsageCommon;
import de.qfm.erp.common.response.entityusage.EntityUsagePageCommon;
import de.qfm.erp.service.service.route.EntityUsageRoute;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(description="Entity Usage Resource", name="Resource")
@OpenAPIDefinition(tags={@Tag(name="Resource", description="All Operations around Entity Usages")})
@RestController
@RequestMapping(value={"/api/v1/erp/entityusages"})
public class EntityUsageResource {
    private static final Logger log = LogManager.getLogger(EntityUsageResource.class);
    private final EntityUsageRoute route;

    @Operation(summary="EntityUsage List / Paging")
    @GetMapping(value={"/"})
    public EntityUsagePageCommon page(@RequestParam(value="page", defaultValue="0") int page, @RequestParam(value="size", defaultValue="100") int size) {
        return this.route.page(page, size);
    }

    @Operation(summary="HistoryItem for Id")
    @GetMapping(value={"/{id}/"})
    public EntityUsageCommon getById(@PathVariable(value="id") long id) {
        return this.route.byId(id);
    }

    @Operation(summary="Paged EntityUse Page for Use Type and Entity Type, sorted by Creation Date Descending")
    @GetMapping(value={"/{entity_class}/"}, produces={"application/json"})
    public EntityUsagePageCommon getByClassAndId(@Parameter(example="QUOTATION, MEASUREMENT", description="The Entity Class of the Required History", required=true) @PathVariable(value="entity_class") String entityClazzCandidate, @Parameter(description="The Page index starting at 0", example="0") @RequestParam(value="page", defaultValue="0") int page, @Parameter(description="The Page Size", example="100") @RequestParam(value="size", defaultValue="100") int size) {
        return this.route.page(entityClazzCandidate, page, size);
    }

    public EntityUsageResource(EntityUsageRoute route) {
        this.route = route;
    }
}

