/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.common.request.entity.EntityFilterRequest;
import de.qfm.erp.common.request.quotation.QEntityAliasUpdateRequest;
import de.qfm.erp.common.request.quotation.QEntityUpdateRequest;
import de.qfm.erp.common.response.quotation.EntityCommon;
import de.qfm.erp.common.response.quotation.EntityDashboardListCommon;
import de.qfm.erp.common.response.quotation.QEntityAutoCompleteResponse;
import de.qfm.erp.common.response.quotation.QEntityNextAddendumNumberResponse;
import de.qfm.erp.common.response.quotation.QEntityTreePageCommon;
import de.qfm.erp.common.response.quotation.QStagesTreeListCommon;
import de.qfm.erp.common.response.quotation.StageListCommon;
import de.qfm.erp.service.service.route.EntityRoute;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.time.LocalDate;
import java.time.LocalDateTime;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Tag(description="QEntity Management Resource", name="QEntityResource")
@OpenAPIDefinition(tags={@Tag(name="QEntityResource", description="All Operations around QEntites")})
@ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully retrieved Entity / List", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="401", description="You are not authorized to view the resource", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="403", description="Accessing the resource you were trying to reach is forbidden", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="The resource you were trying to reach is not found", content={@Content(mediaType="application/json")})})
@RestController
@RequestMapping(value={"/api/v2/erp/qentities"})
public class EntityResource {
    private static final Logger log = LogManager.getLogger(EntityResource.class);
    private EntityRoute route;

    @Operation(summary="QEntity Paging")
    @GetMapping(value={"/"}, produces={"application/json"})
    public QEntityTreePageCommon pageAsTree(@RequestParam(value="page", defaultValue="0") int page, @RequestParam(value="size", defaultValue="100") int size, @RequestParam(value="filter_text", defaultValue="") String filterText, @RequestParam(value="filter_customer_id", required=false) Long filterCustomerId, @RequestParam(value="flag_show_cost_units", defaultValue="false") boolean flagShowCostUnits, @RequestParam(value="flag_include_archived", defaultValue="false") boolean flagIncludeArchived) {
        return this.route.pageAsTree(page, size, StringUtils.trimToEmpty((String)filterText), filterCustomerId, true, flagIncludeArchived);
    }

    @Operation(summary="Entity Paging as List")
    @PostMapping(value={"/_dashboard/"}, consumes={"application/json"}, produces={"application/json"})
    public EntityDashboardListCommon pageAsList(@RequestBody @Valid EntityFilterRequest entityFilterRequest) {
        Integer page = (Integer)MoreObjects.firstNonNull((Object)entityFilterRequest.getPage(), (Object)1);
        Integer size = (Integer)MoreObjects.firstNonNull((Object)entityFilterRequest.getSize(), (Object)100);
        String filterText = StringUtils.trimToEmpty((String)entityFilterRequest.getFilterText());
        String sort = StringUtils.trimToEmpty((String)entityFilterRequest.getSort());
        LocalDateTime submissionDateTimeUntil = entityFilterRequest.getSubmissionDateTimeUntil();
        LocalDate plannedSubmissionDateUntil = entityFilterRequest.getPlannedSubmissionDateUntil();
        LocalDate executionPeriodFrom = entityFilterRequest.getExecutionPeriodFrom();
        LocalDate executionPeriodTo = entityFilterRequest.getExecutionPeriodTo();
        Iterable filterProjectTeamIds = (Iterable)MoreObjects.firstNonNull((Object)entityFilterRequest.getFilterProjectTeamIds(), (Object)ImmutableSet.of());
        Iterable filterPersonResponsibleIds = (Iterable)MoreObjects.firstNonNull((Object)entityFilterRequest.getFilterPersonResponsibleIds(), (Object)ImmutableSet.of());
        Iterable filterCustomerIds = (Iterable)MoreObjects.firstNonNull((Object)entityFilterRequest.getFilterCustomerIds(), (Object)ImmutableSet.of());
        Iterable filterEntityStates = (Iterable)MoreObjects.firstNonNull((Object)entityFilterRequest.getFilterEntityStates(), (Object)ImmutableSet.of());
        return this.route.pageAsList(page.intValue(), size.intValue(), filterText, submissionDateTimeUntil, plannedSubmissionDateUntil, executionPeriodFrom, executionPeriodTo, filterProjectTeamIds, filterPersonResponsibleIds, filterCustomerIds, filterEntityStates, sort);
    }

    @Operation(summary="QEntity by Id")
    @GetMapping(value={"/{id}/"}, produces={"application/json"})
    public EntityCommon byId(@PathVariable(value="id") long id) {
        return this.route.byId(id);
    }

    @Operation(summary="QEntity.Stages by Id")
    @GetMapping(value={"/{id}/stages/"}, produces={"application/json"})
    public StageListCommon stagesById(@PathVariable(value="id") long id) {
        return this.route.stagesById(id);
    }

    @Operation(summary="Quotation for Id")
    @GetMapping(value={"/{id}/_tree/"}, produces={"application/json"})
    public QStagesTreeListCommon treeById(@PathVariable(value="id") long id, @Parameter(description="filter archived = true, excludes all stages with state=archived", example="false") @RequestParam(value="filter_archived", defaultValue="false") Boolean filterArchivedCand) {
        boolean filterArchived = (Boolean)MoreObjects.firstNonNull((Object)filterArchivedCand, (Object)false);
        return this.route.treeById(id, filterArchived);
    }

    @Operation(summary="Create a QEntity")
    @PostMapping(value={"/"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public EntityCommon update(@Valid @RequestBody QEntityUpdateRequest updateRequest) {
        return this.route.update(updateRequest);
    }

    @Operation(summary="Update QEntity for a given Id")
    @PostMapping(value={"/{id}/"}, consumes={"application/json"}, produces={"application/json"})
    public EntityCommon updateForId(@PathVariable(value="id") Long id, @Valid @RequestBody QEntityUpdateRequest updateRequest) {
        return this.route.update(id, updateRequest);
    }

    @Operation(summary="Update QEntity.Alias for a given Id")
    @PostMapping(value={"/{id}/_alias/"}, consumes={"application/json"}, produces={"application/json"})
    public EntityCommon updateForId(@PathVariable(value="id") Long id, @Valid @RequestBody QEntityAliasUpdateRequest aliasUpdateRequest) {
        return this.route.update(id, aliasUpdateRequest);
    }

    @Operation(summary="Determine the next available AddendumNumber within a QEntity for a given Id")
    @GetMapping(value={"/{id}/_next_addendum_number/"}, produces={"application/json"})
    public QEntityNextAddendumNumberResponse nextAddendumNumber(@PathVariable(value="id") Long id, @Parameter(description="exclude stage (id) from this determination", example="") @RequestParam(value="exclude_stage_id", defaultValue="") Long excludeStageId) {
        return this.route.nextAddendumNumber(id, excludeStageId);
    }

    @Operation(summary="QEntity AutoComplete")
    @GetMapping(value={"/_autocomplete/"}, produces={"application/json"})
    public QEntityAutoCompleteResponse autocomplete(@Parameter(description="filter autocomplete by text") @RequestParam(value="filter_text", defaultValue="") String filterText, @Parameter(description="Mode: ALL = all including inactive, REPORT = Reporting Purposes Only", example="ALL, REPORT") @RequestParam(value="autocomplete_mode", defaultValue="ALL") String autoCompleteMode) {
        return this.route.standardAutoComplete(StringUtils.trimToEmpty((String)filterText), StringUtils.trimToEmpty((String)autoCompleteMode));
    }

    public EntityResource(EntityRoute route) {
        this.route = route;
    }
}

