/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import com.google.common.base.MoreObjects;
import de.qfm.erp.common.request.customer.v2.CustomerUpdateRequest;
import de.qfm.erp.common.response.customer.AddressAutoCompleteResponse;
import de.qfm.erp.common.response.customer.AddressCommon;
import de.qfm.erp.common.response.customer.ContactPersonAutoCompleteResponse;
import de.qfm.erp.common.response.customer.CustomerAutoCompleteResponse;
import de.qfm.erp.common.response.customer.CustomerCommon;
import de.qfm.erp.common.response.customer.CustomerPageCommon;
import de.qfm.erp.common.response.customer.CustomerQEntitiesPageCommon;
import de.qfm.erp.common.response.customer.CustomerSharepointResponse;
import de.qfm.erp.service.service.route.CustomerRoute;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(description="Customer V2 Management Resource", name="CustomerResource V2")
@OpenAPIDefinition(tags={@Tag(name="CustomerResource V2", description="All Operations around Customers")})
@ApiResponses(value={@ApiResponse(responseCode="400", description="Something went wrong", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="403", description="Access denied", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="401", description="Expired or invalid JWT token", content={@Content(mediaType="application/json")})})
@RestController
@RequestMapping(value={"/api/v2/erp/customers"})
public class CustomerResource {
    private static final Logger log = LogManager.getLogger(CustomerResource.class);
    private final CustomerRoute route;

    @Operation(summary="Customer List / Paging")
    @GetMapping(value={"/"})
    public CustomerPageCommon list(@RequestParam(value="page", defaultValue="0") int page, @RequestParam(value="size", defaultValue="10000") int size, @Parameter(description="filter Customers by Text") @RequestParam(value="filter_text", defaultValue="") String filterText, @Parameter(description="include archived", example="false", examples={@ExampleObject(value="true"), @ExampleObject(value="false")}) @RequestParam(value="flag_include_archived", defaultValue="false") Boolean flagIncludeArchivedCand) {
        boolean flagIncludeArchived = (Boolean)MoreObjects.firstNonNull((Object)flagIncludeArchivedCand, (Object)false);
        return this.route.page(page, size, StringUtils.trimToEmpty((String)filterText), flagIncludeArchived);
    }

    @Operation(summary="Customer by Id", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=CustomerCommon.class))})})
    @GetMapping(value={"/{id}/"}, produces={"application/json"})
    public CustomerCommon getById(@PathVariable(value="id") long id) {
        return this.route.byId(id);
    }

    @Operation(summary="Create a Customer")
    @PostMapping(value={"/"}, consumes={"application/json"}, produces={"application/json"})
    public CustomerCommon update(@RequestBody CustomerUpdateRequest updateRequest) {
        return this.route.update(updateRequest);
    }

    @Operation(summary="Update Customer by Id")
    @PostMapping(value={"/{id}/"}, consumes={"application/json"}, produces={"application/json"})
    public CustomerCommon updateForId(@PathVariable(value="id") long id, @RequestBody CustomerUpdateRequest updateRequest) {
        return this.route.update(id, updateRequest);
    }

    @Operation(summary="Create a Customer from Inquiry")
    @PostMapping(value={"/_from_inquiry/"}, consumes={"application/json"}, produces={"application/json"})
    public CustomerCommon fromInquiry(@RequestBody CustomerUpdateRequest updateRequest) {
        return this.route.fromInquiry(updateRequest);
    }

    @Operation(summary="Update Customer by Id from Inquiry")
    @PostMapping(value={"/{id}/_from_inquiry/"}, consumes={"application/json"}, produces={"application/json"})
    public CustomerCommon fromInquiryById(@PathVariable(value="id") long id, @RequestBody CustomerUpdateRequest updateRequest) {
        return this.route.fromInquiry(id, updateRequest);
    }

    @Operation(summary="Get QEntities for Customer by Id")
    @GetMapping(value={"/{id}/qentities/"}, produces={"application/json"})
    public CustomerQEntitiesPageCommon qEntitiesByCustomerId(@PathVariable(value="id") long id) {
        return this.route.qEntitiesById(id);
    }

    @Operation(summary="Customer AutoComplete")
    @GetMapping(value={"/_autocomplete/"}, produces={"application/json"})
    public CustomerAutoCompleteResponse autocomplete(@Parameter(description="include archived", example="false", examples={@ExampleObject(value="true"), @ExampleObject(value="false")}) @RequestParam(value="flag_include_archived", defaultValue="false") Boolean flagIncludeArchivedCand, @Parameter(description="Filter by 'any' Text", example="") @RequestParam(value="filter_text", defaultValue="") String filterText) {
        boolean flagIncludeArchived = (Boolean)MoreObjects.firstNonNull((Object)flagIncludeArchivedCand, (Object)false);
        return this.route.autoComplete(flagIncludeArchived, filterText);
    }

    @Operation(summary="Address By ID")
    @GetMapping(value={"/addresses/{id}/"}, produces={"application/json"})
    public AddressCommon addressById(@PathVariable(value="id") Long id) {
        return this.route.addressById(id);
    }

    @Operation(summary="Address AutoComplete")
    @GetMapping(value={"/addresses/_autocomplete/"}, produces={"application/json"})
    public AddressAutoCompleteResponse addressAutocomplete(@Parameter(description="Filter by Customer Id", example="") @RequestParam(value="filter_customer_id", defaultValue="") Long filterCustomerId, @Parameter(description="Filter by 'any' Text", example="") @RequestParam(value="filter_text", defaultValue="") String filterText, @Parameter(description="Filter by Address Type", example="", examples={@ExampleObject(value="PRIMARY"), @ExampleObject(value="SECONDARY"), @ExampleObject(value="AGENT"), @ExampleObject(value="INVOICE"), @ExampleObject(value="QUOTATION")}) @RequestParam(value="filter_address_type", defaultValue="") String filterAddressType) {
        return this.route.addressAutoComplete(filterCustomerId, StringUtils.trimToEmpty((String)filterText), StringUtils.trimToEmpty((String)filterAddressType));
    }

    @Operation(summary="Contact Person AutoComplete")
    @GetMapping(value={"/contact_persons/_autocomplete/"}, produces={"application/json"})
    public ContactPersonAutoCompleteResponse contactPersonAutocomplete(@Parameter(description="Filter by Customer Id", example="") @RequestParam(value="filter_customer_id", defaultValue="") Long filterCustomerId, @Parameter(description="Filter by 'any' Text", example="") @RequestParam(value="filter_text", defaultValue="") String filterText) {
        return this.route.contactPersonAutoComplete(filterCustomerId, filterText);
    }

    @Operation(summary="Set new State for Customer with Id")
    @PostMapping(value={"/{id}/_state/{new_state}/"}, consumes={"application/json"}, produces={"application/json"})
    public CustomerCommon updateStateForId(@Parameter(description="Customer Id of the Customer to Change State", required=true) @PathVariable(value="id") long id, @Parameter(description="new State for Measurement", example="TEMPORARY,ACTIVE,ARCHIVED", required=true) @PathVariable(value="new_state") String newStateCandidate) {
        return this.route.updateStateForId(id, newStateCandidate);
    }

    @Operation(summary="Fetch Sharepoint State by Id")
    @GetMapping(value={"/{id}/_sharepoint/"}, produces={"application/json"})
    public CustomerSharepointResponse sharepointById(@PathVariable(value="id") long id) {
        return this.route.sharepointById(id);
    }

    public CustomerResource(CustomerRoute route) {
        this.route = route;
    }
}

