/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import de.qfm.erp.common.request.generic.BankingHolidayUpdateRequest;
import de.qfm.erp.common.response.DeleteResponse;
import de.qfm.erp.common.response.generic.BankingHolidayCommon;
import de.qfm.erp.common.response.generic.BankingHolidayPageCommon;
import de.qfm.erp.service.service.route.BankingHolidayRoute;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(description="Banking Holiday Management Resource", name="BankingHolidayResource")
@OpenAPIDefinition(tags={@Tag(name="BankingHolidayResource", description="All Operations around Banking Holidays")})
@ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully retrieved Entity / List", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="401", description="You are not authorized to view the resource", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="403", description="Accessing the resource you were trying to reach is forbidden", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="The resource you were trying to reach is not found", content={@Content(mediaType="application/json")})})
@RestController
@RequestMapping(value={"/api/v1/erp/banking_holidays"})
public class BankingHolidayResource {
    private static final Logger log = LogManager.getLogger(BankingHolidayResource.class);
    private final BankingHolidayRoute route;

    @Operation(summary="Banking Holidays List / Paging")
    @GetMapping(value={"/"}, produces={"application/json"})
    public BankingHolidayPageCommon list(@RequestParam(value="page", defaultValue="0") int page, @RequestParam(value="size", defaultValue="100") int size) {
        return this.route.page(page, size);
    }

    @Operation(summary="Banking Holiday for Id")
    @GetMapping(value={"/{id}/"}, produces={"application/json"})
    public BankingHolidayCommon getById(@Parameter(description="Banking Holiday Id of the Entity to retrieve", required=true) @PathVariable(value="id") long id) {
        return this.route.byId(id);
    }

    @Operation(summary="Banking Holiday for Id")
    @DeleteMapping(value={"/{id}/"}, produces={"application/json"})
    public DeleteResponse deleteById(@Parameter(description="Banking Holiday Id of the Entity to delete", required=true) @PathVariable(value="id") long id) {
        return this.route.deleteById(id);
    }

    @Operation(summary="Create BankingHoliday  Item")
    @PostMapping(value={"/"}, consumes={"application/json"}, produces={"application/json"})
    public BankingHolidayCommon create(@Valid @RequestBody BankingHolidayUpdateRequest updateRequest) {
        return this.route.create(updateRequest);
    }

    @Operation(summary="Update BankingHoliday Item by Id")
    @PostMapping(value={"/{id}/"}, consumes={"application/json"}, produces={"application/json"})
    public BankingHolidayCommon updateById(@Parameter(description="Banking Holiday Item Id of the Entity to update", required=true) @PathVariable(value="id") long id, @Valid @RequestBody BankingHolidayUpdateRequest updateRequest) {
        return this.route.update(id, updateRequest);
    }

    public BankingHolidayResource(BankingHolidayRoute route) {
        this.route = route;
    }
}

