/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import de.qfm.erp.common.request.user.UserLoginRequest;
import de.qfm.erp.common.response.user.JWTTokenResponse;
import de.qfm.erp.common.response.user.UserCommon;
import de.qfm.erp.service.service.route.AuthenticationRoute;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.servlet.http.HttpServletRequest;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/erp/auth"})
public class AuthenticationResource {
    private static final Logger log = LogManager.getLogger(AuthenticationResource.class);
    private final AuthenticationRoute authenticationRoute;

    @PostMapping(value={"/_signin/"})
    @Operation(summary="Sign In Operation", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=JWTTokenResponse.class))})})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="Something went wrong"), @ApiResponse(responseCode="422", description="Invalid username/password supplied")})
    public JWTTokenResponse login(@RequestBody UserLoginRequest userLoginRequest) {
        String userName = userLoginRequest.getUsername();
        String password = userLoginRequest.getPassword();
        return this.authenticationRoute.signIn(userName, password);
    }

    @GetMapping(value={"/_me/"})
    @Operation(summary="Based on the Token - Login / User-Profile", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=UserCommon.class))})})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="Something went wrong"), @ApiResponse(responseCode="403", description="Access denied"), @ApiResponse(responseCode="401", description="Expired or invalid JWT token")})
    public UserCommon whoAmI(@NonNull HttpServletRequest req) {
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        return this.authenticationRoute.whoAmI(req);
    }

    @Operation(summary="Refresh Token on Validation Lifetime End", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=UserCommon.class))})})
    @PostMapping(value={"/_refresh/"})
    public JWTTokenResponse refresh(@NonNull HttpServletRequest req) {
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        return this.authenticationRoute.refresh(req);
    }

    public AuthenticationResource(AuthenticationRoute authenticationRoute) {
        this.authenticationRoute = authenticationRoute;
    }
}

