/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.repository;

import de.qfm.erp.service.model.jpa.EPsxNotifyState;
import de.qfm.erp.service.model.jpa.quotation.QEntity;
import de.qfm.erp.service.model.jpa.search.ESearchIndexState;
import de.qfm.erp.service.repository.BaseRepository;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface QEntityRepository
extends JpaRepository<QEntity, Long>,
JpaSpecificationExecutor<QEntity>,
BaseRepository {
    public static final LocalDateTime LOCAL_DATE_TIME_MIN = LocalDateTime.of(2000, 1, 1, 0, 0, 0);
    public static final LocalDateTime LOCAL_DATE_TIME_MAX = LocalDateTime.of(2100, 1, 1, 0, 0, 0);
    public static final LocalDate LOCAL_DATE_MIN = LocalDate.of(2000, 1, 1);
    public static final LocalDate LOCAL_DATE_MAX = LocalDate.of(2100, 1, 1);

    @Query(value="SELECT q FROM QEntity q WHERE   q.searchIndexState in :searchIndexStates")
    @Nonnull
    public List<QEntity> findAllUnIndexed(@Param(value="searchIndexStates") @NonNull Iterable<ESearchIndexState> var1, @NonNull Pageable var2);

    @Modifying
    @Query(value="update QEntity q set q.searchIndexState = :searchIndexState where q.id in :entityIds")
    public int updateSearchIndexState(@Param(value="searchIndexState") @NonNull ESearchIndexState var1, @Param(value="entityIds") @NonNull Iterable<Long> var2);

    @Modifying
    @Query(value="update QEntity q set q.psxNotifyState = :psxNotifyState where q.id in :entityIds")
    public int updatePsxNotifyState(@Param(value="psxNotifyState") @NonNull EPsxNotifyState var1, @Param(value="entityIds") @NonNull Iterable<Long> var2);

    @Query(value="select e FROM QEntity e WHERE e.psxNotifyState = 'NOT_NOTIFIED' order by e.id")
    @Nonnull
    public List<QEntity> nextNotNotified(@NonNull Pageable var1);
}

