/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.repository;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import de.qfm.erp.service.model.internal.costcenter.CostCenterFilter;
import de.qfm.erp.service.model.internal.costcenter.ECostCenterFilterType;
import de.qfm.erp.service.model.internal.payroll.IAggregatedPayrollUser;
import de.qfm.erp.service.model.internal.payroll.PayrollMonthFilter;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceDayType;
import de.qfm.erp.service.model.jpa.employee.payroll.EPayrollItemClazz;
import de.qfm.erp.service.model.jpa.employee.payroll.EPayrollMonthState;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonthItem;
import de.qfm.erp.service.model.jpa.quotation.EQStageState;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.repository.BaseRepository;
import de.qfm.erp.service.repository.PayrollMonthRepository;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Subquery;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface PayrollMonthRepository
extends JpaRepository<PayrollMonth, Long>,
JpaSpecificationExecutor<PayrollMonth> {
    @Nonnull
    public static Specification<PayrollMonth> filter(@NonNull PayrollMonthFilter payrollMonthFilter) {
        if (payrollMonthFilter == null) {
            throw new NullPointerException("payrollMonthFilter is marked non-null but is null");
        }
        return (Specification & Serializable)(root, cq, builder) -> {
            boolean includeInactive;
            boolean includeTemporary;
            LocalDate localDate;
            CostCenterFilter costCenterFilter = payrollMonthFilter.getCostCenterFilter();
            String costCenter = costCenterFilter.getCostCenter();
            ECostCenterFilterType costCenterFilterType = costCenterFilter.getCostCenterFilterType();
            Range accountingMonth = payrollMonthFilter.getAccountingMonth();
            ArrayList predicates = Lists.newArrayList();
            switch (1.$SwitchMap$de$qfm$erp$service$model$internal$costcenter$ECostCenterFilterType[costCenterFilterType.ordinal()]) {
                case 1: {
                    predicates.add(builder.equal((Expression)root.get("costCenter"), (Object)costCenter));
                }
                case 2: {
                    predicates.add(builder.like((Expression)root.get("costCenter"), costCenter + "%"));
                }
            }
            if (accountingMonth.hasLowerBound()) {
                localDate = (LocalDate)accountingMonth.lowerEndpoint();
                predicates.add(builder.greaterThanOrEqualTo((Expression)root.get("accountingMonth"), (Comparable)localDate));
            }
            if (accountingMonth.hasUpperBound()) {
                localDate = (LocalDate)accountingMonth.upperEndpoint();
                predicates.add(builder.lessThanOrEqualTo((Expression)root.get("accountingMonth"), (Comparable)localDate));
            }
            if (!(includeTemporary = payrollMonthFilter.isIncludeTemporary())) {
                predicates.add(root.get("payrollMonthState").in((Collection)ImmutableSet.copyOf((Iterable)EPayrollMonthState.ALL_ACTIVE)));
            }
            if (!(includeInactive = payrollMonthFilter.isIncludeInactive())) {
                LocalDate referenceDate = (LocalDate)accountingMonth.lowerEndpoint();
                YearMonth referenceMonth = YearMonth.from(referenceDate);
                LocalDate referenceMonthBegin = referenceMonth.atDay(1);
                LocalDate referenceMonthEnd = referenceMonth.atEndOfMonth();
                Join userJoin = root.join("user");
                Join userCC = userJoin.join("userCostCenters");
                Path validBeginPathCC = userCC.get("validBegin");
                Path validEndPathCC = userCC.get("validEnd");
                predicates.add(builder.and((Expression)builder.lessThanOrEqualTo((Expression)validBeginPathCC, (Comparable)referenceMonthEnd), (Expression)builder.greaterThanOrEqualTo((Expression)validEndPathCC, (Comparable)referenceMonthBegin)));
                Join userEC = userJoin.join("employeeContracts");
                Path validBeginPathEC = userEC.get("validBegin");
                Path validEndPathEC = userEC.get("validEnd");
                predicates.add(builder.and((Expression)builder.lessThanOrEqualTo((Expression)validBeginPathEC, (Comparable)referenceMonthEnd), (Expression)builder.greaterThanOrEqualTo((Expression)validEndPathEC, (Comparable)referenceMonthBegin)));
            }
            return builder.and(predicates.toArray(new Predicate[0]));
        };
    }

    @Nonnull
    public static Optional<Specification<PayrollMonth>> accountingMonthBetween(@NonNull Range<LocalDate> accountingMonthRange) {
        if (accountingMonthRange == null) {
            throw new NullPointerException("accountingMonthRange is marked non-null but is null");
        }
        if (accountingMonthRange.isEmpty()) {
            return Optional.empty();
        }
        LocalDate from = ((LocalDate)accountingMonthRange.lowerEndpoint()).withDayOfMonth(1);
        LocalDate to = ((LocalDate)accountingMonthRange.upperEndpoint()).withDayOfMonth(1);
        Specification & Serializable specification = (Specification & Serializable)(root, query, builder) -> {
            Expression accountingMonth = BaseRepository.truncToMonth((CriteriaBuilder)builder, (Path)root.get("accountingMonth"));
            return builder.between(accountingMonth, (Comparable)from, (Comparable)to);
        };
        return Optional.of(specification);
    }

    @Nonnull
    public static Optional<Specification<PayrollMonth>> noQuotationNumberEnded(@NonNull Join<PayrollMonth, PayrollMonthItem> childrenProd) {
        if (childrenProd == null) {
            throw new NullPointerException("childrenProd is marked non-null but is null");
        }
        Specification & Serializable specification = (Specification & Serializable)(root, query, builder) -> {
            Subquery subQuery = query.subquery(Quotation.class);
            Root subRoot = subQuery.from(Quotation.class);
            Predicate joinPredicate = builder.equal((Expression)childrenProd.get("quotationNumber"), (Expression)subRoot.get("quotationNumber"));
            Predicate stageEndPredicate = builder.or((Expression)builder.equal((Expression)subRoot.get("flagOrderEnd"), (Object)true), (Expression)subRoot.get("stageState").in((Collection)ImmutableSet.of((Object)EQStageState.ARCHIVED)));
            subQuery.select((Expression)subRoot).where(new Predicate[]{joinPredicate, stageEndPredicate});
            return builder.exists(subQuery).not();
        };
        return Optional.of(specification);
    }

    @Nonnull
    public static Optional<Predicate> sendersIn(@NonNull Join<PayrollMonth, PayrollMonthItem> childrenProd, @NonNull Iterable<User> senders) {
        if (childrenProd == null) {
            throw new NullPointerException("childrenProd is marked non-null but is null");
        }
        if (senders == null) {
            throw new NullPointerException("senders is marked non-null but is null");
        }
        if (Iterables.isEmpty(senders)) {
            return Optional.empty();
        }
        Predicate predicate = childrenProd.get("sender").in((Collection)ImmutableSet.copyOf(senders));
        return Optional.of(predicate);
    }

    @Nonnull
    public static Optional<Predicate> payrollItemClazzIn(@NonNull Join<PayrollMonth, PayrollMonthItem> childrenProd_P_PMI, @NonNull Iterable<EPayrollItemClazz> payrollItemClazzes) {
        if (childrenProd_P_PMI == null) {
            throw new NullPointerException("childrenProd_P_PMI is marked non-null but is null");
        }
        if (payrollItemClazzes == null) {
            throw new NullPointerException("payrollItemClazzes is marked non-null but is null");
        }
        if (Iterables.isEmpty(payrollItemClazzes)) {
            return Optional.empty();
        }
        return Optional.of(childrenProd_P_PMI.get("payrollItemClazz").in((Collection)ImmutableSet.copyOf(payrollItemClazzes)));
    }

    @Nonnull
    public static Optional<Predicate> quotationNumberIn(@NonNull Join<PayrollMonth, PayrollMonthItem> childrenProd_P_PMI, @NonNull Iterable<String> quotationNumbers) {
        if (childrenProd_P_PMI == null) {
            throw new NullPointerException("childrenProd_P_PMI is marked non-null but is null");
        }
        if (quotationNumbers == null) {
            throw new NullPointerException("quotationNumbers is marked non-null but is null");
        }
        if (!Iterables.isEmpty(quotationNumbers)) {
            return Optional.of(childrenProd_P_PMI.get("quotationNumber").in((Collection)ImmutableSet.copyOf(quotationNumbers)));
        }
        return Optional.empty();
    }

    @Nonnull
    public Optional<PayrollMonth> findByReferenceId(@NonNull String var1);

    @Nonnull
    public Optional<PayrollMonth> findByUserAndAccountingMonth(@NonNull User var1, @NonNull LocalDate var2);

    @Nonnull
    public Iterable<PayrollMonth> findByUserInAndAccountingMonth(@NonNull Iterable<User> var1, @NonNull LocalDate var2);

    @Nonnull
    public Iterable<PayrollMonth> findByAccountingMonthGreaterThanEqual(@NonNull LocalDate var1);

    @Query(value="select p from PayrollMonth p left join p.attendances a left join p.user u where u.id != :excludeUserId  and p.accountingMonth = :accountingMonth  and a.employeeDayType in :employeeDayTypes")
    @Nonnull
    public Iterable<PayrollMonth> payrollMonthsWithAttendanceDayTypes(@Param(value="excludeUserId") @NonNull Long var1, @Param(value="accountingMonth") @NonNull LocalDate var2, @Param(value="employeeDayTypes") @NonNull Iterable<EAttendanceDayType> var3);

    @Query(value="SELECT   p.id as payrollMonthId, cc.costCenter as costCenter, c.id as contractId, u.id as userId FROM    PayrollMonth p    JOIN p.user u    JOIN u.userCostCenters cc    JOIN u.employeeContracts ec    JOIN ec.laborUnionContract c WHERE    p.accountingMonth = :accountingMonth    AND p.payrollMonthState = :payrollMonthState    AND cc.validBegin <= :accountingMonth AND cc.validEnd >= :accountingMonth    AND ec.validBegin <= :accountingMonth AND ec.validEnd >= :accountingMonth ORDER BY p.id")
    @Nonnull
    public Iterable<IAggregatedPayrollUser> payrollIdAndUserIdForMonth(@Param(value="accountingMonth") @NonNull LocalDate var1, @Param(value="payrollMonthState") @NonNull EPayrollMonthState var2);

    @Nonnull
    public Iterable<PayrollMonth> findReleasedPayrollMonthsByUserInAndAccountingMonthEqualsAndPayrollMonthStateIn(@NonNull Iterable<User> var1, @NonNull LocalDate var2, @NonNull Iterable<EPayrollMonthState> var3);

    @Query(value="select p.id from PayrollMonth p join p.user u where p.id in :ids order by u.personalNumber")
    public Iterable<Long> idsSortedByPersonalNumber(@NonNull Iterable<Long> var1);

    @Query(value="select p.id from PayrollMonth p join p.user u where p.id in :ids order by u.lastName, u.firstName")
    public Iterable<Long> idsSortedByName(@NonNull Iterable<Long> var1);
}

