/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.repository;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import de.qfm.erp.service.model.jpa.generic.DictionaryItem;
import de.qfm.erp.service.model.jpa.history.type.EEntityClass;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.stereotype.Repository;

/*
 * Exception performing whole class analysis ignored.
 */
@Repository
public interface DictionaryItemRepository
extends JpaRepository<DictionaryItem, Long>,
JpaSpecificationExecutor<DictionaryItem> {
    public static final Splitter SEARCH_SPLITTER = Splitter.on((char)' ').omitEmptyStrings();

    @Nonnull
    public static Specification<DictionaryItem> filter(@NonNull String text, @NonNull Iterable<EEntityClass> entityClasses, @NonNull Iterable<Pair<EEntityClass, Long>> entities, boolean includeHidden) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (entityClasses == null) {
            throw new NullPointerException("entityClasses is marked non-null but is null");
        }
        if (entities == null) {
            throw new NullPointerException("entities is marked non-null but is null");
        }
        return (Specification & Serializable)(root, cq, cb) -> {
            ArrayList predicates = Lists.newArrayList();
            DictionaryItemRepository.textFilter((String)text, (Root)root, (CriteriaBuilder)cb).forEach(predicates::add);
            DictionaryItemRepository.entityClassFilter((Iterable)entityClasses, (Root)root, (CriteriaBuilder)cb).forEach(predicates::add);
            DictionaryItemRepository.entityFilter((Iterable)entities, (Root)root, (CriteriaBuilder)cb).forEach(predicates::add);
            DictionaryItemRepository.hidden((boolean)includeHidden, (Root)root, (CriteriaBuilder)cb).forEach(predicates::add);
            return cb.and(predicates.toArray(new Predicate[0]));
        };
    }

    @Nonnull
    public static Iterable<Predicate> entityClassFilter(@NonNull Iterable<EEntityClass> entityClasses, @NonNull Root<DictionaryItem> root, @NonNull CriteriaBuilder cb) {
        if (entityClasses == null) {
            throw new NullPointerException("entityClasses is marked non-null but is null");
        }
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        if (cb == null) {
            throw new NullPointerException("cb is marked non-null but is null");
        }
        ImmutableList.Builder predicateBuilder = ImmutableList.builder();
        if (!Iterables.isEmpty(entityClasses)) {
            predicateBuilder.add((Object)cb.and(new Predicate[]{root.get("entityClass").in((Collection)ImmutableSet.copyOf(entityClasses))}));
        }
        return predicateBuilder.build();
    }

    @Nonnull
    public static Iterable<Predicate> entityFilter(@NonNull Iterable<Pair<EEntityClass, Long>> entities, @NonNull Root<DictionaryItem> root, @NonNull CriteriaBuilder cb) {
        if (entities == null) {
            throw new NullPointerException("entities is marked non-null but is null");
        }
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        if (cb == null) {
            throw new NullPointerException("cb is marked non-null but is null");
        }
        ImmutableList.Builder conjunction = ImmutableList.builder();
        if (!Iterables.isEmpty(entities)) {
            ArrayList disjunctions = Lists.newArrayList();
            for (Pair<EEntityClass, Long> entity : entities) {
                disjunctions.add(cb.and((Expression)cb.equal((Expression)root.get("entityClass"), entity.getLeft()), (Expression)cb.equal((Expression)root.get("entityId"), entity.getRight())));
            }
            conjunction.add((Object)cb.or(disjunctions.toArray(new Predicate[0])));
        }
        return conjunction.build();
    }

    @Nonnull
    public static Iterable<Predicate> textFilter(@NonNull String text, Root<DictionaryItem> root, CriteriaBuilder cb) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        ImmutableList.Builder predicateBuilder = ImmutableList.builder();
        ImmutableList terms = ImmutableList.copyOf(SEARCH_SPLITTER.split((CharSequence)text).iterator());
        for (String term : terms) {
            String lowerTerm = StringUtils.lowerCase((String)term);
            predicateBuilder.add((Object)cb.or(new Predicate[]{cb.like(cb.lower((Expression)root.get("name")), "%" + lowerTerm + "%")}));
        }
        return predicateBuilder.build();
    }

    @Nonnull
    public static Iterable<Predicate> hidden(boolean includeHidden, Root<DictionaryItem> root, CriteriaBuilder cb) {
        ImmutableList.Builder predicateBuilder = ImmutableList.builder();
        if (!includeHidden) {
            predicateBuilder.add((Object)cb.or((Expression)cb.equal((Expression)root.get("flagHidden"), (Object)false), (Expression)cb.isNull((Expression)root.get("flagHidden"))));
        }
        return predicateBuilder.build();
    }
}

