/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.search;

import de.qfm.erp.service.model.search.PreparedQuery;
import lombok.NonNull;

public class InternalSearchRequest {
    @NonNull
    private final PreparedQuery preparedQuery;
    private final int page;
    private final int size;

    private InternalSearchRequest(@NonNull PreparedQuery preparedQuery, int page, int size) {
        if (preparedQuery == null) {
            throw new NullPointerException("preparedQuery is marked non-null but is null");
        }
        this.preparedQuery = preparedQuery;
        this.page = page;
        this.size = size;
    }

    public static InternalSearchRequest of(@NonNull PreparedQuery preparedQuery, int page, int size) {
        if (preparedQuery == null) {
            throw new NullPointerException("preparedQuery is marked non-null but is null");
        }
        return new InternalSearchRequest(preparedQuery, page, size);
    }

    @NonNull
    public PreparedQuery getPreparedQuery() {
        return this.preparedQuery;
    }

    public int getPage() {
        return this.page;
    }

    public int getSize() {
        return this.size;
    }

    public String toString() {
        return "InternalSearchRequest(preparedQuery=" + String.valueOf(this.getPreparedQuery()) + ", page=" + this.getPage() + ", size=" + this.getSize() + ")";
    }
}

