/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.search;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.model.search.IndexField;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum ECustomerIndexField implements IndexField
{
    UNKNOWN("unknown"),
    _ID("_id"),
    _SOURCE("_source"),
    _TYPE("_type"),
    _ALL("_all"),
    ENTRY_TYPE("entry_type"),
    CUSTOMER__ID("customer.id"),
    CUSTOMER__ENTITY_STATE("customer.entity_state"),
    CUSTOMER__CREATED_ON("customer.created_on"),
    CUSTOMER__CREATED_BY("customer.created_by"),
    CUSTOMER__UPDATED_ON("customer.updated_on"),
    CUSTOMER__UPDATED_BY("customer.updated_by"),
    CUSTOMER__NAME("customer.name"),
    CUSTOMER__DEBTOR_ACCOUNT_NUMBER("customer.debtor_account_number"),
    CUSTOMER__CUSTOMER_STATE("customer.customer_state"),
    CUSTOMER__CUSTOMER_TYPE("customer.customer_type"),
    CUSTOMER__ADDRESS("customer.customer_address"),
    SORT_CUSTOMER__CREATED_ON("sort.customer.created_on"),
    SORT_CUSTOMER__UPDATED_ON("sort.customer.updated_on"),
    SPELLCHECK__CLAZZ("spellcheck_clazz"),
    SPELLCHECK__FIELD("spellcheck_field"),
    SPELLCHECK__VALUE("spellcheck_value"),
    SPELLCHECK__PHONETIC("spellcheck_phonetic"),
    SPELLCHECK__LENGTH("spellcheck_length");

    private final String fieldName;
    private static final Map<String, ECustomerIndexField> LOOKUP;
    @Nonnull
    public static final Iterable<IndexField> STRING_QUERY_FIELDS;
    @Nonnull
    public static final Iterable<ECustomerIndexField> CUSTOMER__FULLTEXT_QUERY_FIELDS;
    @Nonnull
    public static final Iterable<IndexField> NUMERIC_FIELDS;
    @Nonnull
    public static final Iterable<IndexField> CATCH_ALL_FIELDS;

    private ECustomerIndexField(String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        this.fieldName = fieldName;
    }

    @Nonnull
    public static Iterable<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static ECustomerIndexField lookup(@NonNull String candidate, @NonNull ECustomerIndexField defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return ECustomerIndexField.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<ECustomerIndexField> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = ECustomerIndexField.key((String)candidate);
        return Optional.ofNullable((ECustomerIndexField)LOOKUP.get(key));
    }

    @Nonnull
    private static String key(@NonNull ECustomerIndexField hint) {
        if (hint == null) {
            throw new NullPointerException("hint is marked non-null but is null");
        }
        return ECustomerIndexField.key((String)hint.fieldName());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @Nonnull
    public String fieldName() {
        return this.fieldName;
    }

    @Nonnull
    public Iterable<IndexField> numericFields() {
        return ImmutableList.of();
    }

    @Nonnull
    public Iterable<IndexField> copyFields() {
        return ImmutableList.of();
    }

    @Nonnull
    public String messageCode() {
        return "index_field." + this.fieldName;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ECustomerIndexField value : ECustomerIndexField.values()) {
            String key = ECustomerIndexField.key((ECustomerIndexField)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
        STRING_QUERY_FIELDS = ImmutableSet.of((Object)CUSTOMER__NAME, (Object)CUSTOMER__ADDRESS);
        CUSTOMER__FULLTEXT_QUERY_FIELDS = ImmutableSet.of((Object)CUSTOMER__NAME, (Object)CUSTOMER__DEBTOR_ACCOUNT_NUMBER, (Object)CUSTOMER__ADDRESS);
        NUMERIC_FIELDS = ImmutableSet.of((Object)CUSTOMER__DEBTOR_ACCOUNT_NUMBER);
        CATCH_ALL_FIELDS = ImmutableSet.builder().addAll(STRING_QUERY_FIELDS).addAll(NUMERIC_FIELDS).build();
    }
}

