/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.search;

import com.google.common.collect.ImmutableList;
import de.qfm.erp.service.model.search.CustomerSearchResultItem;
import de.qfm.erp.service.model.search.IndexSearchResult;
import de.qfm.erp.service.model.search.InternalSearchRequest;
import de.qfm.erp.service.model.search.timing.TimingResult;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.NonNull;

public class CustomerIndexSearchResult
extends IndexSearchResult<CustomerSearchResultItem> {
    public CustomerIndexSearchResult(@NonNull InternalSearchRequest searchRequest, long totalHits, int totalPages, @NonNull List<CustomerSearchResultItem> searchResultItems, @NonNull TimingResult timing) {
        super(searchRequest, totalHits, totalPages, searchResultItems, timing);
        if (searchRequest == null) {
            throw new NullPointerException("searchRequest is marked non-null but is null");
        }
        if (searchResultItems == null) {
            throw new NullPointerException("searchResultItems is marked non-null but is null");
        }
        if (timing == null) {
            throw new NullPointerException("timing is marked non-null but is null");
        }
    }

    @Nonnull
    public static CustomerIndexSearchResult of(@NonNull InternalSearchRequest searchRequest, long totalHits, int totalPages, @NonNull List<CustomerSearchResultItem> items, @NonNull TimingResult timingResult) {
        if (searchRequest == null) {
            throw new NullPointerException("searchRequest is marked non-null but is null");
        }
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        if (timingResult == null) {
            throw new NullPointerException("timingResult is marked non-null but is null");
        }
        return new CustomerIndexSearchResult(searchRequest, totalHits, totalPages, (List)ImmutableList.copyOf(items), timingResult);
    }

    public boolean isEmpty() {
        return this.getItems().isEmpty();
    }

    public String toString() {
        return "CustomerIndexSearchResult()";
    }
}

