/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.quotation;

import de.qfm.erp.service.helper.NullStringConverter;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.shared.EAlternativePositionType;
import de.qfm.erp.service.model.jpa.shared.EPositionType;
import jakarta.persistence.Basic;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Set;
import org.hibernate.Hibernate;

@Entity(name="QuotationPosition")
@Table(name="QUOTATION_POSITION")
public class QuotationPosition
extends EntityBase {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="QUOTATION_POSITION_SEQ")
    @SequenceGenerator(sequenceName="QUOTATION_POSITION_SEQ", allocationSize=50, name="QUOTATION_POSITION_SEQ")
    private Long id;
    @Deprecated(forRemoval=true)
    @Column(name="reference_id", length=50)
    private String referenceId;
    @Convert(converter=NullStringConverter.class)
    @Column(name="position_number", length=20)
    private String positionNumber;
    @Column(name="sub_position_number")
    private Integer subPositionNumber;
    @Convert(converter=NullStringConverter.class)
    @Column(name="surrogate_position_number", length=75)
    private String surrogatePositionNumber;
    @Convert(converter=NullStringConverter.class)
    @Column(name="position_number_external", length=75)
    private String positionNumberExternal;
    @Deprecated
    @Convert(converter=NullStringConverter.class)
    @Column(name="flag_alternative_position", length=10)
    private String flagAlternativePosition;
    @Deprecated(forRemoval=true)
    @Column(name="addendum_number")
    private Long addendumNumber;
    @Convert(converter=NullStringConverter.class)
    @Column(name="group_level_1", length=9)
    private String groupingElementLevel1;
    @Convert(converter=NullStringConverter.class)
    @Column(name="group_level_2", length=9)
    private String groupingElementLevel2;
    @Convert(converter=NullStringConverter.class)
    @Column(name="group_level_3", length=9)
    private String groupingElementLevel3;
    @Convert(converter=NullStringConverter.class)
    @Column(name="group_level_4", length=9)
    private String groupingElementLevel4;
    @Column(name="seq_number_quote_standard")
    private Integer sequenceNumberQuotationStandard;
    @Column(name="ordered_amount")
    private BigDecimal orderedAmount;
    @Convert(converter=NullStringConverter.class)
    @Column(name="unit", length=40)
    private String unit;
    @Deprecated
    @Column(name="unit_amount")
    private BigDecimal unitAmount;
    @Convert(converter=NullStringConverter.class)
    @Column(name="article_code", length=15)
    private String articleCode;
    @Convert(converter=NullStringConverter.class)
    @Column(name="article_name", length=120)
    private String articleName;
    @Convert(converter=NullStringConverter.class)
    @Column(name="supplier_code", length=5)
    private String supplierCode;
    @Convert(converter=NullStringConverter.class)
    @Column(name="short_text", length=500)
    private String shortText;
    @Convert(converter=NullStringConverter.class)
    @Column(name="short_text_original", length=500)
    private String shortTextOriginal;
    @Basic(fetch=FetchType.EAGER)
    @Convert(converter=NullStringConverter.class)
    @Lob
    @Column(name="long_text", length=100000)
    private String longText;
    @Basic(fetch=FetchType.EAGER)
    @Convert(converter=NullStringConverter.class)
    @Lob
    @Column(name="long_text_original", length=100000)
    private String longTextOriginal;
    @Convert(converter=NullStringConverter.class)
    @Column(name="bidder_complement_original", length=4000)
    private String bidderComplementOriginal;
    @Convert(converter=NullStringConverter.class)
    @Column(name="bidder_complement", length=4000)
    private String bidderComplement;
    @Column(name="has_bidder_complement")
    private Boolean hasBidderComplement;
    @Column(name="price_per_unit")
    private BigDecimal pricePerUnit;
    @Column(name="wage_per_unit")
    private BigDecimal wagePerUnit;
    @Column(name="squad_wage_per_unit")
    private BigDecimal squadWagePerUnit;
    @Column(name="squad_wage_agg")
    private BigDecimal squadWageAggregated;
    @Column(name="internal_wage_agg")
    private BigDecimal internalWageAggregated;
    @Column(name="mat_whole_price_exc_disc_agg")
    private BigDecimal materialWholesalePriceExcludingDiscountAggregated;
    @Column(name="mat_whole_price_inc_disc_agg")
    private BigDecimal materialWholesalePriceIncludingDiscountAggregated;
    @Column(name="mat_whole_price_exc_disc_pi")
    private BigDecimal materialWholesalePriceExcludingDiscountPerItem;
    @Column(name="mat_whole_price_inc_disc_pi")
    private BigDecimal materialWholesalePriceIncludingDiscountPerItem;
    @Column(name="mat_whole_price_disc")
    private BigDecimal materialWholesalePriceDiscount;
    @Column(name="mat_selling_price_per_unit")
    private BigDecimal materialSellingPricePerUnit;
    @Column(name="mat_selling_price_agg")
    private BigDecimal materialSellingPriceAggregated;
    @Column(name="company_wage_per_item")
    private BigDecimal companyWagePerItem;
    @Column(name="company_wage_agg")
    private BigDecimal companyWageAggregated;
    @Convert(converter=NullStringConverter.class)
    @Column(name="remarks", length=400)
    private String remarks;
    @Deprecated(forRemoval=true)
    @Column(name="material_factor")
    private BigDecimal materialFactor;
    @Deprecated(forRemoval=true)
    @Column(name="wage_factor")
    private BigDecimal wageFactor;
    @Deprecated(forRemoval=true)
    @Column(name="factor_agg")
    private BigDecimal factorAggregated;
    @Column(name="price_aggregated")
    private BigDecimal priceAggregated;
    @Column(name="flag_flat_rate")
    private Boolean flagFlatRate;
    @Enumerated(value=EnumType.STRING)
    @Column(name="position_type", length=50)
    private EPositionType positionType;
    @Enumerated(value=EnumType.STRING)
    @Column(name="jumbo_position_type", length=50)
    private EPositionType jumboPositionType;
    @Enumerated(value=EnumType.STRING)
    @Column(name="alternative_position_type", length=50)
    private EAlternativePositionType alternativePositionType;
    @Column(name="flag_format_bold")
    private Boolean flagFormatBold;
    @Column(name="flag_format_color")
    private Boolean flagFormatColor;
    @Column(name="format_color_code_hex")
    private String formatColorCodeHex;
    @Column(name="material_percentage")
    private BigDecimal materialPercentage;
    @Column(name="wage_percentage")
    private BigDecimal wagePercentage;
    @Column(name="overall_percentage")
    private BigDecimal aggregatedPercentage;
    @Column(name="es_purchase_price_per_unit")
    private BigDecimal externalServicePurchasePricePerUnit;
    @Column(name="es_purchase_price_aggregated")
    private BigDecimal externalServicePurchasePriceAggregated;
    @Column(name="es_percentage")
    private BigDecimal externalServicePercentage;
    @Column(name="es_selling_price_per_unit")
    private BigDecimal externalServiceSellingPricePerUnit;
    @Column(name="es_selling_price_aggregated")
    private BigDecimal externalServiceSellingPriceAggregated;
    @Column(name="flag_fee_position")
    private Boolean flagFeePosition;
    @Column(name="locked_cells_bitmask")
    private Long lockedCellsBitmask;
    @JoinColumn(name="parent_position_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private QuotationPosition parent;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="parent", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<QuotationPosition> children;
    @JoinColumn(name="reference_position_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private QuotationPosition referencePosition;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="referencePosition")
    private Set<QuotationPosition> referencePositions;
    @JoinColumn(name="quotation_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private Quotation quotation;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass((Object)this) != Hibernate.getClass((Object)o)) {
            return false;
        }
        QuotationPosition that = (QuotationPosition)o;
        return this.getId() != null && Objects.equals(this.getId(), that.getId());
    }

    public int hashCode() {
        return Hibernate.getClass((Object)this).hashCode();
    }

    public Long getId() {
        return this.id;
    }

    @Deprecated
    public String getReferenceId() {
        return this.referenceId;
    }

    public String getPositionNumber() {
        return this.positionNumber;
    }

    public Integer getSubPositionNumber() {
        return this.subPositionNumber;
    }

    public String getSurrogatePositionNumber() {
        return this.surrogatePositionNumber;
    }

    public String getPositionNumberExternal() {
        return this.positionNumberExternal;
    }

    @Deprecated
    public String getFlagAlternativePosition() {
        return this.flagAlternativePosition;
    }

    @Deprecated
    public Long getAddendumNumber() {
        return this.addendumNumber;
    }

    public String getGroupingElementLevel1() {
        return this.groupingElementLevel1;
    }

    public String getGroupingElementLevel2() {
        return this.groupingElementLevel2;
    }

    public String getGroupingElementLevel3() {
        return this.groupingElementLevel3;
    }

    public String getGroupingElementLevel4() {
        return this.groupingElementLevel4;
    }

    public Integer getSequenceNumberQuotationStandard() {
        return this.sequenceNumberQuotationStandard;
    }

    public BigDecimal getOrderedAmount() {
        return this.orderedAmount;
    }

    public String getUnit() {
        return this.unit;
    }

    @Deprecated
    public BigDecimal getUnitAmount() {
        return this.unitAmount;
    }

    public String getArticleCode() {
        return this.articleCode;
    }

    public String getArticleName() {
        return this.articleName;
    }

    public String getSupplierCode() {
        return this.supplierCode;
    }

    public String getShortText() {
        return this.shortText;
    }

    public String getShortTextOriginal() {
        return this.shortTextOriginal;
    }

    public String getLongText() {
        return this.longText;
    }

    public String getLongTextOriginal() {
        return this.longTextOriginal;
    }

    public String getBidderComplementOriginal() {
        return this.bidderComplementOriginal;
    }

    public String getBidderComplement() {
        return this.bidderComplement;
    }

    public Boolean getHasBidderComplement() {
        return this.hasBidderComplement;
    }

    public BigDecimal getPricePerUnit() {
        return this.pricePerUnit;
    }

    public BigDecimal getWagePerUnit() {
        return this.wagePerUnit;
    }

    public BigDecimal getSquadWagePerUnit() {
        return this.squadWagePerUnit;
    }

    public BigDecimal getSquadWageAggregated() {
        return this.squadWageAggregated;
    }

    public BigDecimal getInternalWageAggregated() {
        return this.internalWageAggregated;
    }

    public BigDecimal getMaterialWholesalePriceExcludingDiscountAggregated() {
        return this.materialWholesalePriceExcludingDiscountAggregated;
    }

    public BigDecimal getMaterialWholesalePriceIncludingDiscountAggregated() {
        return this.materialWholesalePriceIncludingDiscountAggregated;
    }

    public BigDecimal getMaterialWholesalePriceExcludingDiscountPerItem() {
        return this.materialWholesalePriceExcludingDiscountPerItem;
    }

    public BigDecimal getMaterialWholesalePriceIncludingDiscountPerItem() {
        return this.materialWholesalePriceIncludingDiscountPerItem;
    }

    public BigDecimal getMaterialWholesalePriceDiscount() {
        return this.materialWholesalePriceDiscount;
    }

    public BigDecimal getMaterialSellingPricePerUnit() {
        return this.materialSellingPricePerUnit;
    }

    public BigDecimal getMaterialSellingPriceAggregated() {
        return this.materialSellingPriceAggregated;
    }

    public BigDecimal getCompanyWagePerItem() {
        return this.companyWagePerItem;
    }

    public BigDecimal getCompanyWageAggregated() {
        return this.companyWageAggregated;
    }

    public String getRemarks() {
        return this.remarks;
    }

    @Deprecated
    public BigDecimal getMaterialFactor() {
        return this.materialFactor;
    }

    @Deprecated
    public BigDecimal getWageFactor() {
        return this.wageFactor;
    }

    @Deprecated
    public BigDecimal getFactorAggregated() {
        return this.factorAggregated;
    }

    public BigDecimal getPriceAggregated() {
        return this.priceAggregated;
    }

    public Boolean getFlagFlatRate() {
        return this.flagFlatRate;
    }

    public EPositionType getPositionType() {
        return this.positionType;
    }

    public EPositionType getJumboPositionType() {
        return this.jumboPositionType;
    }

    public EAlternativePositionType getAlternativePositionType() {
        return this.alternativePositionType;
    }

    public Boolean getFlagFormatBold() {
        return this.flagFormatBold;
    }

    public Boolean getFlagFormatColor() {
        return this.flagFormatColor;
    }

    public String getFormatColorCodeHex() {
        return this.formatColorCodeHex;
    }

    public BigDecimal getMaterialPercentage() {
        return this.materialPercentage;
    }

    public BigDecimal getWagePercentage() {
        return this.wagePercentage;
    }

    public BigDecimal getAggregatedPercentage() {
        return this.aggregatedPercentage;
    }

    public BigDecimal getExternalServicePurchasePricePerUnit() {
        return this.externalServicePurchasePricePerUnit;
    }

    public BigDecimal getExternalServicePurchasePriceAggregated() {
        return this.externalServicePurchasePriceAggregated;
    }

    public BigDecimal getExternalServicePercentage() {
        return this.externalServicePercentage;
    }

    public BigDecimal getExternalServiceSellingPricePerUnit() {
        return this.externalServiceSellingPricePerUnit;
    }

    public BigDecimal getExternalServiceSellingPriceAggregated() {
        return this.externalServiceSellingPriceAggregated;
    }

    public Boolean getFlagFeePosition() {
        return this.flagFeePosition;
    }

    public Long getLockedCellsBitmask() {
        return this.lockedCellsBitmask;
    }

    public QuotationPosition getParent() {
        return this.parent;
    }

    public Set<QuotationPosition> getChildren() {
        return this.children;
    }

    public QuotationPosition getReferencePosition() {
        return this.referencePosition;
    }

    public Set<QuotationPosition> getReferencePositions() {
        return this.referencePositions;
    }

    public Quotation getQuotation() {
        return this.quotation;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Deprecated
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public void setPositionNumber(String positionNumber) {
        this.positionNumber = positionNumber;
    }

    public void setSubPositionNumber(Integer subPositionNumber) {
        this.subPositionNumber = subPositionNumber;
    }

    public void setSurrogatePositionNumber(String surrogatePositionNumber) {
        this.surrogatePositionNumber = surrogatePositionNumber;
    }

    public void setPositionNumberExternal(String positionNumberExternal) {
        this.positionNumberExternal = positionNumberExternal;
    }

    @Deprecated
    public void setFlagAlternativePosition(String flagAlternativePosition) {
        this.flagAlternativePosition = flagAlternativePosition;
    }

    @Deprecated
    public void setAddendumNumber(Long addendumNumber) {
        this.addendumNumber = addendumNumber;
    }

    public void setGroupingElementLevel1(String groupingElementLevel1) {
        this.groupingElementLevel1 = groupingElementLevel1;
    }

    public void setGroupingElementLevel2(String groupingElementLevel2) {
        this.groupingElementLevel2 = groupingElementLevel2;
    }

    public void setGroupingElementLevel3(String groupingElementLevel3) {
        this.groupingElementLevel3 = groupingElementLevel3;
    }

    public void setGroupingElementLevel4(String groupingElementLevel4) {
        this.groupingElementLevel4 = groupingElementLevel4;
    }

    public void setSequenceNumberQuotationStandard(Integer sequenceNumberQuotationStandard) {
        this.sequenceNumberQuotationStandard = sequenceNumberQuotationStandard;
    }

    public void setOrderedAmount(BigDecimal orderedAmount) {
        this.orderedAmount = orderedAmount;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    @Deprecated
    public void setUnitAmount(BigDecimal unitAmount) {
        this.unitAmount = unitAmount;
    }

    public void setArticleCode(String articleCode) {
        this.articleCode = articleCode;
    }

    public void setArticleName(String articleName) {
        this.articleName = articleName;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    public void setShortText(String shortText) {
        this.shortText = shortText;
    }

    public void setShortTextOriginal(String shortTextOriginal) {
        this.shortTextOriginal = shortTextOriginal;
    }

    public void setLongText(String longText) {
        this.longText = longText;
    }

    public void setLongTextOriginal(String longTextOriginal) {
        this.longTextOriginal = longTextOriginal;
    }

    public void setBidderComplementOriginal(String bidderComplementOriginal) {
        this.bidderComplementOriginal = bidderComplementOriginal;
    }

    public void setBidderComplement(String bidderComplement) {
        this.bidderComplement = bidderComplement;
    }

    public void setHasBidderComplement(Boolean hasBidderComplement) {
        this.hasBidderComplement = hasBidderComplement;
    }

    public void setPricePerUnit(BigDecimal pricePerUnit) {
        this.pricePerUnit = pricePerUnit;
    }

    public void setWagePerUnit(BigDecimal wagePerUnit) {
        this.wagePerUnit = wagePerUnit;
    }

    public void setSquadWagePerUnit(BigDecimal squadWagePerUnit) {
        this.squadWagePerUnit = squadWagePerUnit;
    }

    public void setSquadWageAggregated(BigDecimal squadWageAggregated) {
        this.squadWageAggregated = squadWageAggregated;
    }

    public void setInternalWageAggregated(BigDecimal internalWageAggregated) {
        this.internalWageAggregated = internalWageAggregated;
    }

    public void setMaterialWholesalePriceExcludingDiscountAggregated(BigDecimal materialWholesalePriceExcludingDiscountAggregated) {
        this.materialWholesalePriceExcludingDiscountAggregated = materialWholesalePriceExcludingDiscountAggregated;
    }

    public void setMaterialWholesalePriceIncludingDiscountAggregated(BigDecimal materialWholesalePriceIncludingDiscountAggregated) {
        this.materialWholesalePriceIncludingDiscountAggregated = materialWholesalePriceIncludingDiscountAggregated;
    }

    public void setMaterialWholesalePriceExcludingDiscountPerItem(BigDecimal materialWholesalePriceExcludingDiscountPerItem) {
        this.materialWholesalePriceExcludingDiscountPerItem = materialWholesalePriceExcludingDiscountPerItem;
    }

    public void setMaterialWholesalePriceIncludingDiscountPerItem(BigDecimal materialWholesalePriceIncludingDiscountPerItem) {
        this.materialWholesalePriceIncludingDiscountPerItem = materialWholesalePriceIncludingDiscountPerItem;
    }

    public void setMaterialWholesalePriceDiscount(BigDecimal materialWholesalePriceDiscount) {
        this.materialWholesalePriceDiscount = materialWholesalePriceDiscount;
    }

    public void setMaterialSellingPricePerUnit(BigDecimal materialSellingPricePerUnit) {
        this.materialSellingPricePerUnit = materialSellingPricePerUnit;
    }

    public void setMaterialSellingPriceAggregated(BigDecimal materialSellingPriceAggregated) {
        this.materialSellingPriceAggregated = materialSellingPriceAggregated;
    }

    public void setCompanyWagePerItem(BigDecimal companyWagePerItem) {
        this.companyWagePerItem = companyWagePerItem;
    }

    public void setCompanyWageAggregated(BigDecimal companyWageAggregated) {
        this.companyWageAggregated = companyWageAggregated;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Deprecated
    public void setMaterialFactor(BigDecimal materialFactor) {
        this.materialFactor = materialFactor;
    }

    @Deprecated
    public void setWageFactor(BigDecimal wageFactor) {
        this.wageFactor = wageFactor;
    }

    @Deprecated
    public void setFactorAggregated(BigDecimal factorAggregated) {
        this.factorAggregated = factorAggregated;
    }

    public void setPriceAggregated(BigDecimal priceAggregated) {
        this.priceAggregated = priceAggregated;
    }

    public void setFlagFlatRate(Boolean flagFlatRate) {
        this.flagFlatRate = flagFlatRate;
    }

    public void setPositionType(EPositionType positionType) {
        this.positionType = positionType;
    }

    public void setJumboPositionType(EPositionType jumboPositionType) {
        this.jumboPositionType = jumboPositionType;
    }

    public void setAlternativePositionType(EAlternativePositionType alternativePositionType) {
        this.alternativePositionType = alternativePositionType;
    }

    public void setFlagFormatBold(Boolean flagFormatBold) {
        this.flagFormatBold = flagFormatBold;
    }

    public void setFlagFormatColor(Boolean flagFormatColor) {
        this.flagFormatColor = flagFormatColor;
    }

    public void setFormatColorCodeHex(String formatColorCodeHex) {
        this.formatColorCodeHex = formatColorCodeHex;
    }

    public void setMaterialPercentage(BigDecimal materialPercentage) {
        this.materialPercentage = materialPercentage;
    }

    public void setWagePercentage(BigDecimal wagePercentage) {
        this.wagePercentage = wagePercentage;
    }

    public void setAggregatedPercentage(BigDecimal aggregatedPercentage) {
        this.aggregatedPercentage = aggregatedPercentage;
    }

    public void setExternalServicePurchasePricePerUnit(BigDecimal externalServicePurchasePricePerUnit) {
        this.externalServicePurchasePricePerUnit = externalServicePurchasePricePerUnit;
    }

    public void setExternalServicePurchasePriceAggregated(BigDecimal externalServicePurchasePriceAggregated) {
        this.externalServicePurchasePriceAggregated = externalServicePurchasePriceAggregated;
    }

    public void setExternalServicePercentage(BigDecimal externalServicePercentage) {
        this.externalServicePercentage = externalServicePercentage;
    }

    public void setExternalServiceSellingPricePerUnit(BigDecimal externalServiceSellingPricePerUnit) {
        this.externalServiceSellingPricePerUnit = externalServiceSellingPricePerUnit;
    }

    public void setExternalServiceSellingPriceAggregated(BigDecimal externalServiceSellingPriceAggregated) {
        this.externalServiceSellingPriceAggregated = externalServiceSellingPriceAggregated;
    }

    public void setFlagFeePosition(Boolean flagFeePosition) {
        this.flagFeePosition = flagFeePosition;
    }

    public void setLockedCellsBitmask(Long lockedCellsBitmask) {
        this.lockedCellsBitmask = lockedCellsBitmask;
    }

    public void setParent(QuotationPosition parent) {
        this.parent = parent;
    }

    public void setChildren(Set<QuotationPosition> children) {
        this.children = children;
    }

    public void setReferencePosition(QuotationPosition referencePosition) {
        this.referencePosition = referencePosition;
    }

    public void setReferencePositions(Set<QuotationPosition> referencePositions) {
        this.referencePositions = referencePositions;
    }

    public void setQuotation(Quotation quotation) {
        this.quotation = quotation;
    }

    public String toString() {
        return "QuotationPosition(super=" + super.toString() + ", id=" + this.getId() + ", referenceId=" + this.getReferenceId() + ", positionNumber=" + this.getPositionNumber() + ", subPositionNumber=" + this.getSubPositionNumber() + ", surrogatePositionNumber=" + this.getSurrogatePositionNumber() + ", positionNumberExternal=" + this.getPositionNumberExternal() + ", flagAlternativePosition=" + this.getFlagAlternativePosition() + ", addendumNumber=" + this.getAddendumNumber() + ", groupingElementLevel1=" + this.getGroupingElementLevel1() + ", groupingElementLevel2=" + this.getGroupingElementLevel2() + ", groupingElementLevel3=" + this.getGroupingElementLevel3() + ", groupingElementLevel4=" + this.getGroupingElementLevel4() + ", sequenceNumberQuotationStandard=" + this.getSequenceNumberQuotationStandard() + ", orderedAmount=" + String.valueOf(this.getOrderedAmount()) + ", unit=" + this.getUnit() + ", unitAmount=" + String.valueOf(this.getUnitAmount()) + ", articleCode=" + this.getArticleCode() + ", articleName=" + this.getArticleName() + ", supplierCode=" + this.getSupplierCode() + ", shortText=" + this.getShortText() + ", shortTextOriginal=" + this.getShortTextOriginal() + ", longText=" + this.getLongText() + ", longTextOriginal=" + this.getLongTextOriginal() + ", bidderComplementOriginal=" + this.getBidderComplementOriginal() + ", bidderComplement=" + this.getBidderComplement() + ", hasBidderComplement=" + this.getHasBidderComplement() + ", pricePerUnit=" + String.valueOf(this.getPricePerUnit()) + ", wagePerUnit=" + String.valueOf(this.getWagePerUnit()) + ", squadWagePerUnit=" + String.valueOf(this.getSquadWagePerUnit()) + ", squadWageAggregated=" + String.valueOf(this.getSquadWageAggregated()) + ", internalWageAggregated=" + String.valueOf(this.getInternalWageAggregated()) + ", materialWholesalePriceExcludingDiscountAggregated=" + String.valueOf(this.getMaterialWholesalePriceExcludingDiscountAggregated()) + ", materialWholesalePriceIncludingDiscountAggregated=" + String.valueOf(this.getMaterialWholesalePriceIncludingDiscountAggregated()) + ", materialWholesalePriceExcludingDiscountPerItem=" + String.valueOf(this.getMaterialWholesalePriceExcludingDiscountPerItem()) + ", materialWholesalePriceIncludingDiscountPerItem=" + String.valueOf(this.getMaterialWholesalePriceIncludingDiscountPerItem()) + ", materialWholesalePriceDiscount=" + String.valueOf(this.getMaterialWholesalePriceDiscount()) + ", materialSellingPricePerUnit=" + String.valueOf(this.getMaterialSellingPricePerUnit()) + ", materialSellingPriceAggregated=" + String.valueOf(this.getMaterialSellingPriceAggregated()) + ", companyWagePerItem=" + String.valueOf(this.getCompanyWagePerItem()) + ", companyWageAggregated=" + String.valueOf(this.getCompanyWageAggregated()) + ", remarks=" + this.getRemarks() + ", materialFactor=" + String.valueOf(this.getMaterialFactor()) + ", wageFactor=" + String.valueOf(this.getWageFactor()) + ", factorAggregated=" + String.valueOf(this.getFactorAggregated()) + ", priceAggregated=" + String.valueOf(this.getPriceAggregated()) + ", flagFlatRate=" + this.getFlagFlatRate() + ", positionType=" + String.valueOf(this.getPositionType()) + ", jumboPositionType=" + String.valueOf(this.getJumboPositionType()) + ", alternativePositionType=" + String.valueOf(this.getAlternativePositionType()) + ", flagFormatBold=" + this.getFlagFormatBold() + ", flagFormatColor=" + this.getFlagFormatColor() + ", formatColorCodeHex=" + this.getFormatColorCodeHex() + ", materialPercentage=" + String.valueOf(this.getMaterialPercentage()) + ", wagePercentage=" + String.valueOf(this.getWagePercentage()) + ", aggregatedPercentage=" + String.valueOf(this.getAggregatedPercentage()) + ", externalServicePurchasePricePerUnit=" + String.valueOf(this.getExternalServicePurchasePricePerUnit()) + ", externalServicePurchasePriceAggregated=" + String.valueOf(this.getExternalServicePurchasePriceAggregated()) + ", externalServicePercentage=" + String.valueOf(this.getExternalServicePercentage()) + ", externalServiceSellingPricePerUnit=" + String.valueOf(this.getExternalServiceSellingPricePerUnit()) + ", externalServiceSellingPriceAggregated=" + String.valueOf(this.getExternalServiceSellingPriceAggregated()) + ", flagFeePosition=" + this.getFlagFeePosition() + ", lockedCellsBitmask=" + this.getLockedCellsBitmask() + ")";
    }
}

