/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.queue;

import de.qfm.erp.service.helper.NullIntegerConverter;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.queue.EQueueItemType;
import de.qfm.erp.service.model.jpa.queue.EReferenceType;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;

@Entity(name="QueueItem")
@Table(name="QUEUE_ITEM")
public class QueueItem
extends EntityBase {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="QUEUE_SEQ")
    @SequenceGenerator(sequenceName="QUEUE_SEQ", allocationSize=1, name="QUEUE_SEQ")
    private int id;
    @Column(name="queue_item_type", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private EQueueItemType queueItemType;
    @Column(name="reference_type", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private EReferenceType referenceType;
    @Column(name="reference_id", nullable=false)
    private Long referenceId;
    @Convert(converter=NullIntegerConverter.class)
    @Column(name="failure_amount", nullable=false)
    private Integer failureAmount;

    public int getId() {
        return this.id;
    }

    public EQueueItemType getQueueItemType() {
        return this.queueItemType;
    }

    public EReferenceType getReferenceType() {
        return this.referenceType;
    }

    public Long getReferenceId() {
        return this.referenceId;
    }

    public Integer getFailureAmount() {
        return this.failureAmount;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setQueueItemType(EQueueItemType queueItemType) {
        this.queueItemType = queueItemType;
    }

    public void setReferenceType(EReferenceType referenceType) {
        this.referenceType = referenceType;
    }

    public void setReferenceId(Long referenceId) {
        this.referenceId = referenceId;
    }

    public void setFailureAmount(Integer failureAmount) {
        this.failureAmount = failureAmount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueueItem)) {
            return false;
        }
        QueueItem other = (QueueItem)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        Long this$referenceId = this.getReferenceId();
        Long other$referenceId = other.getReferenceId();
        if (this$referenceId == null ? other$referenceId != null : !((Object)this$referenceId).equals(other$referenceId)) {
            return false;
        }
        Integer this$failureAmount = this.getFailureAmount();
        Integer other$failureAmount = other.getFailureAmount();
        if (this$failureAmount == null ? other$failureAmount != null : !((Object)this$failureAmount).equals(other$failureAmount)) {
            return false;
        }
        EQueueItemType this$queueItemType = this.getQueueItemType();
        EQueueItemType other$queueItemType = other.getQueueItemType();
        if (this$queueItemType == null ? other$queueItemType != null : !this$queueItemType.equals(other$queueItemType)) {
            return false;
        }
        EReferenceType this$referenceType = this.getReferenceType();
        EReferenceType other$referenceType = other.getReferenceType();
        return !(this$referenceType == null ? other$referenceType != null : !this$referenceType.equals(other$referenceType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueueItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getId();
        Long $referenceId = this.getReferenceId();
        result = result * 59 + ($referenceId == null ? 43 : ((Object)$referenceId).hashCode());
        Integer $failureAmount = this.getFailureAmount();
        result = result * 59 + ($failureAmount == null ? 43 : ((Object)$failureAmount).hashCode());
        EQueueItemType $queueItemType = this.getQueueItemType();
        result = result * 59 + ($queueItemType == null ? 43 : $queueItemType.hashCode());
        EReferenceType $referenceType = this.getReferenceType();
        result = result * 59 + ($referenceType == null ? 43 : $referenceType.hashCode());
        return result;
    }

    public String toString() {
        return "QueueItem(super=" + super.toString() + ", id=" + this.getId() + ", queueItemType=" + String.valueOf(this.getQueueItemType()) + ", referenceType=" + String.valueOf(this.getReferenceType()) + ", referenceId=" + this.getReferenceId() + ", failureAmount=" + this.getFailureAmount() + ")";
    }
}

