/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.measurement.type;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.service.validator.Validator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EMeasurementType implements Translatable
{
    NONE("none"),
    PARTIAL("partial"),
    MAIN("main");

    private final String value;
    private static final Map<String, EMeasurementType> LOOKUP;
    public static final Set<EMeasurementType> PREVENT_FURTHER_PSS_MEASUREMENT_TYPES;
    public static final Set<EMeasurementType> ALLOW_FURTHER_PSS_MEASUREMENT_TYPES;

    private EMeasurementType(String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.value = value;
    }

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EMeasurementType lookup(@NonNull String candidate, @NonNull EMeasurementType defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EMeasurementType.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EMeasurementType> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EMeasurementType.key((String)candidate);
        return Optional.ofNullable((EMeasurementType)LOOKUP.get(key));
    }

    @NonNull
    public static EMeasurementType lookupFailing(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        Optional measurementTypeCandidate = EMeasurementType.lookup((String)candidate);
        if (measurementTypeCandidate.isEmpty()) {
            throw Validator.throwEnumException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.MEASUREMENT_TYPE), (String)candidate, EMeasurementType.class, EMeasurementType::allowedKeys);
        }
        return (EMeasurementType)measurementTypeCandidate.get();
    }

    @Nonnull
    private static String key(@NonNull EMeasurementType item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return EMeasurementType.key((String)item.getValue());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @Nonnull
    public String messageCode() {
        return "enum.measurement_type." + this.value;
    }

    public String getValue() {
        return this.value;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EMeasurementType value : EMeasurementType.values()) {
            String key = EMeasurementType.key((EMeasurementType)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
        PREVENT_FURTHER_PSS_MEASUREMENT_TYPES = ImmutableSet.of((Object)MAIN);
        ALLOW_FURTHER_PSS_MEASUREMENT_TYPES = ImmutableSet.of((Object)MAIN);
    }
}

