/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.measurement.type;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.service.validator.Validator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EMeasurementState implements Translatable
{
    UNKNOWN(-1),
    TEMPORARY(1),
    IN_REVIEW(2),
    APPROVED(3),
    RELEASED(4),
    SUBMITTED(5),
    CONFIRMED(6),
    REJECTED(7),
    IN_ACCOUNTING(8),
    ACCOUNTED(9),
    CLOSED(10),
    DELETED(11);

    private static final Map<String, EMeasurementState> LOOKUP;
    private final int sort;
    public static final Set<EMeasurementState> ALL_NON_DELETED;
    public static final Set<EMeasurementState> ALL_VALID;
    public static final Set<EMeasurementState> MEASUREMENT_EDITING_NOT_ALLOWED;
    public static final Set<EMeasurementState> MEASUREMENT_STATES_AFFECTED_IN_QUOTATION_POSITION_DELETION;
    public static final Set<EMeasurementState> ALL_RELEVANT_FOR_WAGE;
    public static final Set<EMeasurementState> ALL_RELEVANT_FOR_FULFILMENT_DEGREE;
    public static final Set<EMeasurementState> CONSTRUCTION_SITE;
    public static final Set<EMeasurementState> NOT_ACCOUNTED_STATES;
    public static final Set<EMeasurementState> AVAILABLE_FOR_INVOICE_B2B;
    public static final Set<EMeasurementState> AVAILABLE_FOR_INVOICE_NON_B2B;
    public static final Set<EMeasurementState> ACCOUNTING_STATES;
    public static final Set<EMeasurementState> ACCOUNTED_STATES;
    public static final Set<EMeasurementState> PSSRO_ALLOW_NEW_MAIN_MEASUREMENT_STATES;
    public static final Set<EMeasurementState> PSSRO_DISALLOW_NEW_MEASUREMENT_STATES;
    public static final Set<EMeasurementState> PSSRO_DISALLOW_NEW_MAIN_MEASUREMENTS;
    public static final Set<EMeasurementState> B2B_BLOCKING_STATES;
    public static final Set<EMeasurementState> B2B_STATES;
    public static final Map<EMeasurementState, Iterable<EMeasurementState>> FOLLOWUP_STATE;
    @Nonnull
    public static final ImmutableBiMap<EMeasurementState, EPrivilege> MEASUREMENT_STATE__PRIVILEGE;
    @Nonnull
    public static final Set<EMeasurementState> EXPLICIT_STATES;
    public static final Map<EMeasurementState, EMeasurementState> POSITIVE_FOLLOW_UP_STATE;
    public static final Map<EMeasurementState, EMeasurementState> NEGATIVE_FOLLOW_UP_STATE;
    public static final Set<EMeasurementState> PREVENT_FURTHER_PSS_MEASUREMENT_STATE;
    public static final Set<EMeasurementState> ALLOW_FURTHER_PSS_MEASUREMENT_STATE;

    private EMeasurementState(int sort) {
        this.sort = sort;
    }

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EMeasurementState lookup(@NonNull String candidate, @NonNull EMeasurementState defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EMeasurementState.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EMeasurementState> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EMeasurementState.key((String)candidate);
        return Optional.ofNullable((EMeasurementState)LOOKUP.get(key));
    }

    @NonNull
    public static EMeasurementState lookupFailing(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EMeasurementState.key((String)candidate);
        EMeasurementState measurementState = (EMeasurementState)LOOKUP.get(key);
        if (null == measurementState) {
            throw Validator.throwEnumException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.MEASUREMENT_STATE), (String)candidate, EMeasurementState.class, EMeasurementState::allowedKeys);
        }
        return measurementState;
    }

    @Nonnull
    private static String key(@NonNull EMeasurementState value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return EMeasurementState.key((String)value.name());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @Nonnull
    public String messageCode() {
        return "enum.measurement_state." + EMeasurementState.key((EMeasurementState)this);
    }

    @Nonnull
    public String key() {
        return EMeasurementState.key((EMeasurementState)this);
    }

    public int getSort() {
        return this.sort;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EMeasurementState value : EMeasurementState.values()) {
            String key = EMeasurementState.key((EMeasurementState)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
        ALL_NON_DELETED = ImmutableSet.of((Object)TEMPORARY, (Object)IN_REVIEW, (Object)APPROVED, (Object)RELEASED, (Object)SUBMITTED, (Object)CONFIRMED, (Object[])new EMeasurementState[]{REJECTED, IN_ACCOUNTING, ACCOUNTED, CLOSED});
        ALL_VALID = ImmutableSet.of((Object)TEMPORARY, (Object)IN_REVIEW, (Object)APPROVED, (Object)RELEASED, (Object)SUBMITTED, (Object)CONFIRMED, (Object[])new EMeasurementState[]{REJECTED, IN_ACCOUNTING, ACCOUNTED, CLOSED, DELETED});
        MEASUREMENT_EDITING_NOT_ALLOWED = ImmutableSet.of((Object)ACCOUNTED, (Object)CLOSED, (Object)DELETED);
        MEASUREMENT_STATES_AFFECTED_IN_QUOTATION_POSITION_DELETION = ImmutableSet.of((Object)UNKNOWN, (Object)TEMPORARY, (Object)IN_REVIEW, (Object)RELEASED, (Object)SUBMITTED, (Object)CONFIRMED, (Object[])new EMeasurementState[]{REJECTED, APPROVED, IN_ACCOUNTING});
        ALL_RELEVANT_FOR_WAGE = ImmutableSet.of((Object)TEMPORARY, (Object)IN_REVIEW, (Object)RELEASED, (Object)SUBMITTED, (Object)CONFIRMED, (Object)REJECTED, (Object[])new EMeasurementState[]{APPROVED, IN_ACCOUNTING, ACCOUNTED, CLOSED});
        ALL_RELEVANT_FOR_FULFILMENT_DEGREE = ImmutableSet.of((Object)TEMPORARY, (Object)IN_REVIEW, (Object)RELEASED, (Object)SUBMITTED, (Object)CONFIRMED, (Object)REJECTED, (Object[])new EMeasurementState[]{APPROVED, IN_ACCOUNTING, ACCOUNTED});
        CONSTRUCTION_SITE = ImmutableSet.of((Object)TEMPORARY, (Object)IN_REVIEW, (Object)RELEASED, (Object)SUBMITTED, (Object)CONFIRMED, (Object)REJECTED, (Object[])new EMeasurementState[]{APPROVED, IN_ACCOUNTING, ACCOUNTED, CLOSED});
        NOT_ACCOUNTED_STATES = ImmutableSet.of((Object)TEMPORARY, (Object)IN_REVIEW, (Object)RELEASED, (Object)SUBMITTED, (Object)CONFIRMED, (Object)REJECTED, (Object[])new EMeasurementState[]{APPROVED, IN_ACCOUNTING});
        AVAILABLE_FOR_INVOICE_B2B = ImmutableSet.of((Object)CONFIRMED);
        AVAILABLE_FOR_INVOICE_NON_B2B = ImmutableSet.of((Object)TEMPORARY, (Object)IN_REVIEW, (Object)RELEASED, (Object)SUBMITTED, (Object)CONFIRMED, (Object)REJECTED, (Object[])new EMeasurementState[]{APPROVED});
        ACCOUNTING_STATES = ImmutableSet.of((Object)ACCOUNTED, (Object)IN_ACCOUNTING);
        ACCOUNTED_STATES = ImmutableSet.of((Object)ACCOUNTED);
        PSSRO_ALLOW_NEW_MAIN_MEASUREMENT_STATES = ImmutableSet.of((Object)DELETED);
        PSSRO_DISALLOW_NEW_MEASUREMENT_STATES = ImmutableSet.of((Object)APPROVED, (Object)IN_ACCOUNTING, (Object)ACCOUNTED);
        PSSRO_DISALLOW_NEW_MAIN_MEASUREMENTS = ImmutableSet.of((Object)TEMPORARY, (Object)IN_REVIEW, (Object)RELEASED, (Object)SUBMITTED, (Object)CONFIRMED, (Object)REJECTED, (Object[])new EMeasurementState[]{APPROVED, IN_ACCOUNTING, ACCOUNTED, CLOSED});
        B2B_BLOCKING_STATES = ImmutableSet.of((Object)RELEASED, (Object)SUBMITTED, (Object)CONFIRMED);
        B2B_STATES = ImmutableSet.of((Object)SUBMITTED, (Object)CONFIRMED, (Object)REJECTED);
        FOLLOWUP_STATE = ImmutableMap.builder().put((Object)UNKNOWN, (Object)ImmutableSet.of((Object)TEMPORARY)).put((Object)TEMPORARY, (Object)ImmutableSet.of((Object)IN_REVIEW)).put((Object)IN_REVIEW, (Object)ImmutableSet.of((Object)APPROVED)).put((Object)APPROVED, (Object)ImmutableSet.of((Object)RELEASED)).put((Object)RELEASED, (Object)ImmutableSet.of((Object)SUBMITTED)).put((Object)SUBMITTED, (Object)ImmutableSet.of((Object)CONFIRMED, (Object)REJECTED)).put((Object)CONFIRMED, (Object)ImmutableSet.of()).put((Object)REJECTED, (Object)ImmutableSet.of()).put((Object)IN_ACCOUNTING, (Object)ImmutableSet.of()).put((Object)ACCOUNTED, (Object)ImmutableSet.of()).put((Object)DELETED, (Object)ImmutableSet.of()).put((Object)CLOSED, (Object)ImmutableSet.of((Object)TEMPORARY)).build();
        MEASUREMENT_STATE__PRIVILEGE = ImmutableBiMap.builder().put((Object)TEMPORARY, (Object)EPrivilege.MEASUREMENT_STATE__TEMPORARY).put((Object)IN_REVIEW, (Object)EPrivilege.MEASUREMENT_STATE__IN_REVIEW).put((Object)APPROVED, (Object)EPrivilege.MEASUREMENT_STATE__APPROVED).put((Object)RELEASED, (Object)EPrivilege.MEASUREMENT_STATE__RELEASED).put((Object)SUBMITTED, (Object)EPrivilege.MEASUREMENT_STATE__SUBMITTED).put((Object)CONFIRMED, (Object)EPrivilege.MEASUREMENT_STATE__CONFIRMED).put((Object)REJECTED, (Object)EPrivilege.MEASUREMENT_STATE__REJECTED).put((Object)CLOSED, (Object)EPrivilege.MEASUREMENT_STATE__CLOSED).build();
        EXPLICIT_STATES = ImmutableSet.of((Object)TEMPORARY, (Object)IN_REVIEW, (Object)APPROVED, (Object)RELEASED, (Object)SUBMITTED, (Object)CONFIRMED, (Object[])new EMeasurementState[]{REJECTED, CLOSED});
        POSITIVE_FOLLOW_UP_STATE = ImmutableMap.builder().put((Object)UNKNOWN, (Object)TEMPORARY).put((Object)TEMPORARY, (Object)IN_REVIEW).put((Object)IN_REVIEW, (Object)APPROVED).put((Object)APPROVED, (Object)RELEASED).put((Object)RELEASED, (Object)SUBMITTED).put((Object)SUBMITTED, (Object)CONFIRMED).put((Object)REJECTED, (Object)RELEASED).build();
        NEGATIVE_FOLLOW_UP_STATE = ImmutableMap.builder().put((Object)IN_REVIEW, (Object)TEMPORARY).put((Object)APPROVED, (Object)IN_REVIEW).put((Object)RELEASED, (Object)APPROVED).put((Object)SUBMITTED, (Object)REJECTED).put((Object)CLOSED, (Object)TEMPORARY).build();
        PREVENT_FURTHER_PSS_MEASUREMENT_STATE = ImmutableSet.of((Object)APPROVED, (Object)ACCOUNTED, (Object)IN_ACCOUNTING);
        ALLOW_FURTHER_PSS_MEASUREMENT_STATE = ImmutableSet.of((Object)TEMPORARY, (Object)IN_REVIEW, (Object)DELETED, (Object)CLOSED);
    }
}

