/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.invoice;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.service.validator.Validator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EInvoiceState implements Translatable
{
    UNKNOWN("unknown"),
    IN_ACCOUNTING("in_accounting"),
    ACCOUNTED("accounted"),
    CANCELLED("cancelled"),
    DELETED("deleted");

    private final String value;
    private static final Map<String, EInvoiceState> LOOKUP;
    @Nonnull
    public static final Iterable<EInvoiceState> INVOICE_STATES_FOR_SECONDARY_INVOICES;
    @Nonnull
    public static final Iterable<EInvoiceState> INVOICE_STATES_FOR_MANUAL_FILTER;
    public static final Iterable<EInvoiceState> ALL_VALID;

    private EInvoiceState(String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.value = value;
    }

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EInvoiceState lookup(@NonNull String candidate, @NonNull EInvoiceState defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EInvoiceState.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EInvoiceState> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EInvoiceState.key((String)candidate);
        return Optional.ofNullable((EInvoiceState)LOOKUP.get(key));
    }

    @NonNull
    public static EInvoiceState lookupFailing(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        Optional measurementViewTypeCandidate = EInvoiceState.lookup((String)candidate);
        if (measurementViewTypeCandidate.isEmpty()) {
            throw Validator.throwEnumException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.INVOICE__INVOICE_STATE), (String)candidate, EInvoiceState.class, EInvoiceState::allowedKeys);
        }
        return (EInvoiceState)measurementViewTypeCandidate.get();
    }

    @Nonnull
    private static String key(@NonNull EInvoiceState item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return EInvoiceState.key((String)item.getValue());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @Nonnull
    public String messageCode() {
        return "enum.invoice_state." + this.value;
    }

    public String getValue() {
        return this.value;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EInvoiceState value : EInvoiceState.values()) {
            String key = EInvoiceState.key((EInvoiceState)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
        INVOICE_STATES_FOR_SECONDARY_INVOICES = ImmutableSet.of((Object)ACCOUNTED);
        INVOICE_STATES_FOR_MANUAL_FILTER = ImmutableSet.of((Object)IN_ACCOUNTING, (Object)ACCOUNTED, (Object)CANCELLED);
        ALL_VALID = ImmutableSet.of((Object)ACCOUNTED, (Object)IN_ACCOUNTING);
    }
}

