/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.history.type;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EHistoryOperation {
    NOTE("note"),
    CREATE("create"),
    UPDATE("update"),
    DELETE("delete");

    private final String value;
    private static final Map<String, EHistoryOperation> LOOKUP;

    private EHistoryOperation(String value) {
        this.value = value;
    }

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EHistoryOperation lookup(@NonNull String candidate, @NonNull EHistoryOperation defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EHistoryOperation.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EHistoryOperation> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EHistoryOperation.key((String)candidate);
        return Optional.ofNullable((EHistoryOperation)LOOKUP.get(key));
    }

    @Nonnull
    private static String key(@NonNull EHistoryOperation eEntityClass) {
        if (eEntityClass == null) {
            throw new NullPointerException("eEntityClass is marked non-null but is null");
        }
        return EHistoryOperation.key((String)eEntityClass.getValue());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    public String getValue() {
        return this.value;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EHistoryOperation value : EHistoryOperation.values()) {
            String key = EHistoryOperation.key((EHistoryOperation)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
    }
}

