/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.generic;

import com.google.common.collect.ImmutableMap;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.service.validator.Validator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EFederalState implements Translatable
{
    UNKNOWN,
    ALL,
    BADEN_WUERTTEMBERG,
    BAYERN,
    BERLIN,
    BRANDENBURG,
    BREMEN,
    HAMBURG,
    HESSEN,
    MECKLENBURG_VORPOMMERN,
    NIEDERSACHSEN,
    NORDRHEIN_WESTFALIEN,
    RHEINLAND_PFALZ,
    SAARLAND,
    SACHSEN,
    SACHSEN_ANHALT,
    SCHLESWIG_HOLSTEIN,
    THUERINGEN;

    private static final Map<String, EFederalState> LOOKUP;

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EFederalState lookup(@NonNull String candidate, @NonNull EFederalState defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EFederalState.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EFederalState> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EFederalState.key((String)candidate);
        return Optional.ofNullable((EFederalState)LOOKUP.get(key));
    }

    @Nonnull
    private static String key(@NonNull EFederalState item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return EFederalState.key((String)item.name());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @Nonnull
    public static EFederalState lookupFailing(String candidate) {
        String key = EFederalState.key((String)candidate);
        EFederalState item = (EFederalState)LOOKUP.get(key);
        if (null == item) {
            throw Validator.throwEnumException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.LABOR_UNION_CONTRACT__FEDERAL_STATE), (String)candidate, EFederalState.class, EFederalState::allowedKeys);
        }
        return item;
    }

    @Nonnull
    public String messageCode() {
        return "enum.federal_state." + EFederalState.key((EFederalState)this);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EFederalState value : EFederalState.values()) {
            String key = EFederalState.key((EFederalState)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
    }
}

