/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.filestore;

import de.qfm.erp.service.helper.NullStringConverter;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.user.User;
import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.sql.Blob;
import java.util.Objects;
import org.hibernate.Hibernate;

@Entity(name="FileStore")
@Table(name="FILE_STORE")
public class FileStore
extends EntityBase {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="FILE_STORE_SEQ")
    @SequenceGenerator(sequenceName="FILE_STORE_SEQ", allocationSize=1, name="FILE_STORE_SEQ")
    private Long id;
    @Convert(converter=NullStringConverter.class)
    @Column(name="uuid", nullable=false)
    private String uuid;
    @Convert(converter=NullStringConverter.class)
    @Column(name="upload_name", nullable=false)
    private String uploadName;
    @Convert(converter=NullStringConverter.class)
    @Column(name="upload_content_type", nullable=false)
    private String uploadContentType;
    @Convert(converter=NullStringConverter.class)
    @Column(name="upload_original_file_name", nullable=false)
    private String uploadOriginalFilename;
    @Column(name="upload_size", nullable=false)
    private long uploadSize;
    @Basic(fetch=FetchType.LAZY)
    @Lob
    @Column(name="data", columnDefinition="BLOB")
    private Blob data;
    @JoinColumn(name="created_by_user_id")
    @ManyToOne(optional=true)
    private User createdByUser;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass((Object)this) != Hibernate.getClass((Object)o)) {
            return false;
        }
        FileStore fileStore = (FileStore)o;
        return this.getId() != null && Objects.equals(this.getId(), fileStore.getId());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public Long getId() {
        return this.id;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getUploadName() {
        return this.uploadName;
    }

    public String getUploadContentType() {
        return this.uploadContentType;
    }

    public String getUploadOriginalFilename() {
        return this.uploadOriginalFilename;
    }

    public long getUploadSize() {
        return this.uploadSize;
    }

    public Blob getData() {
        return this.data;
    }

    public User getCreatedByUser() {
        return this.createdByUser;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setUploadName(String uploadName) {
        this.uploadName = uploadName;
    }

    public void setUploadContentType(String uploadContentType) {
        this.uploadContentType = uploadContentType;
    }

    public void setUploadOriginalFilename(String uploadOriginalFilename) {
        this.uploadOriginalFilename = uploadOriginalFilename;
    }

    public void setUploadSize(long uploadSize) {
        this.uploadSize = uploadSize;
    }

    public void setData(Blob data) {
        this.data = data;
    }

    public void setCreatedByUser(User createdByUser) {
        this.createdByUser = createdByUser;
    }
}

