/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.customer;

import de.qfm.erp.service.helper.NullStringConverter;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.customer.Customer;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.time.LocalDate;
import java.util.Objects;
import org.hibernate.Hibernate;

@Entity(name="ContactPerson")
@Table(name="CONTACT_PERSON")
public class ContactPerson
extends EntityBase {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="CONTACT_PERSON_SEQ")
    @SequenceGenerator(sequenceName="CONTACT_PERSON_SEQ", allocationSize=1, name="CONTACT_PERSON_SEQ")
    private Long id;
    @Convert(converter=NullStringConverter.class)
    @Column(name="title", length=50)
    private String title;
    @Convert(converter=NullStringConverter.class)
    @Column(name="salutation", length=50)
    private String salutation;
    @Convert(converter=NullStringConverter.class)
    @Column(name="first_name", length=250)
    private String firstName;
    @Convert(converter=NullStringConverter.class)
    @Column(name="last_name", length=250)
    private String lastName;
    @Convert(converter=NullStringConverter.class)
    @Column(name="department", length=250)
    private String department;
    @Convert(converter=NullStringConverter.class)
    @Column(name="position", length=250)
    private String position;
    @Convert(converter=NullStringConverter.class)
    @Column(name="phone", length=100)
    private String phone;
    @Convert(converter=NullStringConverter.class)
    @Column(name="cellular", length=100)
    private String cellular;
    @Convert(converter=NullStringConverter.class)
    @Column(name="email", length=250)
    private String email;
    @Convert(converter=NullStringConverter.class)
    @Column(name="remarks", length=250)
    private String remarks;
    @Column(name="birthday_date")
    private LocalDate birthDayDate;
    @Column(name="valid_begin")
    private LocalDate validBegin;
    @Column(name="valid_end")
    private LocalDate validEnd;
    @JoinColumn(name="reference_contact_person_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private ContactPerson referenceContactPerson;
    @JoinColumn(name="customer_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private Customer customer;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass((Object)this) != Hibernate.getClass((Object)o)) {
            return false;
        }
        ContactPerson contactPerson = (ContactPerson)o;
        return this.id != null && Objects.equals(this.id, contactPerson.getId());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public Long getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSalutation() {
        return this.salutation;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getDepartment() {
        return this.department;
    }

    public String getPosition() {
        return this.position;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getCellular() {
        return this.cellular;
    }

    public String getEmail() {
        return this.email;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public LocalDate getBirthDayDate() {
        return this.birthDayDate;
    }

    public LocalDate getValidBegin() {
        return this.validBegin;
    }

    public LocalDate getValidEnd() {
        return this.validEnd;
    }

    public ContactPerson getReferenceContactPerson() {
        return this.referenceContactPerson;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSalutation(String salutation) {
        this.salutation = salutation;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setCellular(String cellular) {
        this.cellular = cellular;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public void setBirthDayDate(LocalDate birthDayDate) {
        this.birthDayDate = birthDayDate;
    }

    public void setValidBegin(LocalDate validBegin) {
        this.validBegin = validBegin;
    }

    public void setValidEnd(LocalDate validEnd) {
        this.validEnd = validEnd;
    }

    public void setReferenceContactPerson(ContactPerson referenceContactPerson) {
        this.referenceContactPerson = referenceContactPerson;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public String toString() {
        return "ContactPerson(super=" + super.toString() + ", id=" + this.getId() + ", title=" + this.getTitle() + ", salutation=" + this.getSalutation() + ", firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ", department=" + this.getDepartment() + ", position=" + this.getPosition() + ", phone=" + this.getPhone() + ", cellular=" + this.getCellular() + ", email=" + this.getEmail() + ", remarks=" + this.getRemarks() + ", birthDayDate=" + String.valueOf(this.getBirthDayDate()) + ", validBegin=" + String.valueOf(this.getValidBegin()) + ", validEnd=" + String.valueOf(this.getValidEnd()) + ")";
    }
}

