/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.businessunit;

import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.businessunit.UserBusinessUnit;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.util.Set;

@Entity(name="BusinessUnit")
@Table(name="BUSINESS_UNIT")
public class BusinessUnit
extends EntityBase {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BUSINESS_UNIT_SEQ")
    @SequenceGenerator(sequenceName="BUSINESS_UNIT_SEQ", allocationSize=1, name="BUSINESS_UNIT_SEQ")
    private Long id;
    @Column(name="short_name", length=50)
    private String shortName;
    @Column(name="long_name", length=250)
    private String longName;
    @Column(name="cost_center", length=15)
    private String costCenter;
    @ManyToOne
    @JoinColumn(name="parent_id")
    private BusinessUnit parent;
    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY)
    private Set<BusinessUnit> children;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="businessUnit")
    private Set<UserBusinessUnit> userBusinessUnits;

    public Long getId() {
        return this.id;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getLongName() {
        return this.longName;
    }

    public String getCostCenter() {
        return this.costCenter;
    }

    public BusinessUnit getParent() {
        return this.parent;
    }

    public Set<BusinessUnit> getChildren() {
        return this.children;
    }

    public Set<UserBusinessUnit> getUserBusinessUnits() {
        return this.userBusinessUnits;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public void setLongName(String longName) {
        this.longName = longName;
    }

    public void setCostCenter(String costCenter) {
        this.costCenter = costCenter;
    }

    public void setParent(BusinessUnit parent) {
        this.parent = parent;
    }

    public void setChildren(Set<BusinessUnit> children) {
        this.children = children;
    }

    public void setUserBusinessUnits(Set<UserBusinessUnit> userBusinessUnits) {
        this.userBusinessUnits = userBusinessUnits;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BusinessUnit)) {
            return false;
        }
        BusinessUnit other = (BusinessUnit)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$shortName = this.getShortName();
        String other$shortName = other.getShortName();
        if (this$shortName == null ? other$shortName != null : !this$shortName.equals(other$shortName)) {
            return false;
        }
        String this$longName = this.getLongName();
        String other$longName = other.getLongName();
        if (this$longName == null ? other$longName != null : !this$longName.equals(other$longName)) {
            return false;
        }
        String this$costCenter = this.getCostCenter();
        String other$costCenter = other.getCostCenter();
        return !(this$costCenter == null ? other$costCenter != null : !this$costCenter.equals(other$costCenter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BusinessUnit;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $shortName = this.getShortName();
        result = result * 59 + ($shortName == null ? 43 : $shortName.hashCode());
        String $longName = this.getLongName();
        result = result * 59 + ($longName == null ? 43 : $longName.hashCode());
        String $costCenter = this.getCostCenter();
        result = result * 59 + ($costCenter == null ? 43 : $costCenter.hashCode());
        return result;
    }

    public String toString() {
        return "BusinessUnit(super=" + super.toString() + ", id=" + this.getId() + ", shortName=" + this.getShortName() + ", longName=" + this.getLongName() + ", costCenter=" + this.getCostCenter() + ")";
    }
}

