/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa;

import com.google.common.base.Objects;
import de.qfm.erp.service.model.jpa.EntityState;
import jakarta.persistence.Column;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.MappedSuperclass;
import java.time.LocalDateTime;

@MappedSuperclass
public abstract class EntityBase {
    @Column(name="created_on", nullable=false, updatable=false)
    protected LocalDateTime createdOn;
    @Column(name="updated_on", nullable=true)
    protected LocalDateTime updatedOn;
    @Column(name="deleted_on", nullable=true)
    protected LocalDateTime deletedOn;
    @Column(name="created_by", nullable=false, updatable=false)
    private String createdBy;
    @Column(name="updated_by", nullable=true)
    protected String updatedBy;
    @Column(name="deleted_by", nullable=true)
    protected String deletedBy;
    @Column(name="entity_state", nullable=false)
    @Enumerated(value=EnumType.STRING)
    protected EntityState entityState;
    @Column(name="row_version", nullable=false)
    protected int rowVersion;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityBase that = (EntityBase)o;
        return this.rowVersion == that.rowVersion && Objects.equal((Object)this.createdOn, (Object)that.createdOn) && Objects.equal((Object)this.updatedOn, (Object)that.updatedOn) && Objects.equal((Object)this.deletedOn, (Object)that.deletedOn) && Objects.equal((Object)this.createdBy, (Object)that.createdBy) && Objects.equal((Object)this.updatedBy, (Object)that.updatedBy) && Objects.equal((Object)this.deletedBy, (Object)that.deletedBy) && this.entityState == that.entityState;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.createdOn, this.updatedOn, this.deletedOn, this.createdBy, this.updatedBy, this.deletedBy, this.entityState, this.rowVersion});
    }

    public String toString() {
        return "EntityBase(createdOn=" + String.valueOf(this.getCreatedOn()) + ", updatedOn=" + String.valueOf(this.getUpdatedOn()) + ", deletedOn=" + String.valueOf(this.getDeletedOn()) + ", createdBy=" + this.getCreatedBy() + ", updatedBy=" + this.getUpdatedBy() + ", deletedBy=" + this.getDeletedBy() + ", entityState=" + String.valueOf(this.getEntityState()) + ", rowVersion=" + this.getRowVersion() + ")";
    }

    public LocalDateTime getCreatedOn() {
        return this.createdOn;
    }

    public LocalDateTime getUpdatedOn() {
        return this.updatedOn;
    }

    public LocalDateTime getDeletedOn() {
        return this.deletedOn;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public String getDeletedBy() {
        return this.deletedBy;
    }

    public EntityState getEntityState() {
        return this.entityState;
    }

    public int getRowVersion() {
        return this.rowVersion;
    }

    public void setCreatedOn(LocalDateTime createdOn) {
        this.createdOn = createdOn;
    }

    public void setUpdatedOn(LocalDateTime updatedOn) {
        this.updatedOn = updatedOn;
    }

    public void setDeletedOn(LocalDateTime deletedOn) {
        this.deletedOn = deletedOn;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public void setDeletedBy(String deletedBy) {
        this.deletedBy = deletedBy;
    }

    public void setEntityState(EntityState entityState) {
        this.entityState = entityState;
    }

    public void setRowVersion(int rowVersion) {
        this.rowVersion = rowVersion;
    }
}

