/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.user;

import com.google.common.collect.ImmutableMap;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.service.validator.Validator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EUniqueUserAttribute implements Translatable
{
    USER_NAME,
    PERSONAL_NUMBER;

    private static final Map<String, EUniqueUserAttribute> LOOKUP;

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EUniqueUserAttribute lookup(@NonNull String candidate, @NonNull EUniqueUserAttribute defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EUniqueUserAttribute.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EUniqueUserAttribute> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EUniqueUserAttribute.key((String)candidate);
        return Optional.ofNullable((EUniqueUserAttribute)LOOKUP.get(key));
    }

    @NonNull
    public static EUniqueUserAttribute lookupFailing(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EUniqueUserAttribute.key((String)candidate);
        EUniqueUserAttribute value = (EUniqueUserAttribute)LOOKUP.get(key);
        if (null == value) {
            throw Validator.throwEnumException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.USER__UNIQUE_ATTRIBUTE_CHECK__ATTRIBUTE), (String)candidate, EUniqueUserAttribute.class, EUniqueUserAttribute::allowedKeys);
        }
        return value;
    }

    @Nonnull
    private static String key(@NonNull EUniqueUserAttribute item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return EUniqueUserAttribute.key((String)item.name());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @Nonnull
    public String messageCode() {
        return "enum.unique_user_attribute." + StringUtils.lowerCase((String)this.name());
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EUniqueUserAttribute value : EUniqueUserAttribute.values()) {
            String key = EUniqueUserAttribute.key((EUniqueUserAttribute)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
    }
}

