/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.print.measurement;

import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import lombok.NonNull;

public class MeasurementPrintBucket {
    @NonNull
    private final Measurement measurement;
    @NonNull
    private final Quotation quotation;
    @NonNull
    private final Quotation rootQuotation;

    private MeasurementPrintBucket(@NonNull Measurement measurement, @NonNull Quotation quotation, @NonNull Quotation rootQuotation) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        if (rootQuotation == null) {
            throw new NullPointerException("rootQuotation is marked non-null but is null");
        }
        this.measurement = measurement;
        this.quotation = quotation;
        this.rootQuotation = rootQuotation;
    }

    public static MeasurementPrintBucket of(@NonNull Measurement measurement, @NonNull Quotation quotation, @NonNull Quotation rootQuotation) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        if (rootQuotation == null) {
            throw new NullPointerException("rootQuotation is marked non-null but is null");
        }
        return new MeasurementPrintBucket(measurement, quotation, rootQuotation);
    }

    @NonNull
    public Measurement getMeasurement() {
        return this.measurement;
    }

    @NonNull
    public Quotation getQuotation() {
        return this.quotation;
    }

    @NonNull
    public Quotation getRootQuotation() {
        return this.rootQuotation;
    }
}

