/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.print.invoice;

import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class InvoicePositionPrintRow {
    private String referenceId;
    private Integer sequenceNumber;
    private String positionNumber;
    private BigDecimal product;
    private String unit;
    private String shortText;
    private String remarks;
    private BigDecimal pricePerUnit;
    private BigDecimal priceAggregated;

    @Nonnull
    public static InvoicePositionPrintRow empty() {
        InvoicePositionPrintRow empty = new InvoicePositionPrintRow();
        empty.setReferenceId("");
        empty.setSequenceNumber(Integer.valueOf(0));
        empty.setPositionNumber("");
        empty.setProduct(BigDecimal.ZERO);
        empty.setUnit("");
        empty.setShortText("");
        empty.setRemarks("");
        empty.setPricePerUnit(BigDecimal.ZERO);
        empty.setPriceAggregated(BigDecimal.ZERO);
        return empty;
    }

    @Nonnull
    public static InvoicePositionPrintRow combine(@NonNull InvoicePositionPrintRow identity, @NonNull InvoicePositionPrintRow right) {
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        if (right == null) {
            throw new NullPointerException("right is marked non-null but is null");
        }
        BigDecimal productL = (BigDecimal)MoreObjects.firstNonNull((Object)identity.getProduct(), (Object)BigDecimal.ZERO);
        BigDecimal productR = (BigDecimal)MoreObjects.firstNonNull((Object)right.getProduct(), (Object)BigDecimal.ZERO);
        BigDecimal productSum = productL.add(productR);
        BigDecimal priceAggregatedL = (BigDecimal)MoreObjects.firstNonNull((Object)identity.getPriceAggregated(), (Object)BigDecimal.ZERO);
        BigDecimal priceAggregatedR = (BigDecimal)MoreObjects.firstNonNull((Object)right.getPriceAggregated(), (Object)BigDecimal.ZERO);
        BigDecimal priceAggregatedSum = priceAggregatedL.add(priceAggregatedR);
        identity.setProduct(productSum);
        identity.setPriceAggregated(priceAggregatedSum);
        InvoicePositionPrintRow.applyString(() -> right.getPositionNumber(), arg_0 -> identity.setPositionNumber(arg_0));
        InvoicePositionPrintRow.applyString(() -> right.getUnit(), arg_0 -> identity.setUnit(arg_0));
        InvoicePositionPrintRow.applyString(() -> right.getShortText(), arg_0 -> identity.setShortText(arg_0));
        InvoicePositionPrintRow.applyString(() -> right.getRemarks(), arg_0 -> identity.setRemarks(arg_0));
        InvoicePositionPrintRow.applyBigDecimal(() -> right.getPricePerUnit(), arg_0 -> identity.setPricePerUnit(arg_0));
        InvoicePositionPrintRow.applyBigDecimal(() -> productSum, arg_0 -> identity.setProduct(arg_0));
        InvoicePositionPrintRow.applyBigDecimal(() -> priceAggregatedSum, arg_0 -> identity.setPriceAggregated(arg_0));
        return identity;
    }

    private static void applyString(@NonNull Supplier<String> supplier, @NonNull Consumer<String> consumer) {
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        consumer.accept(StringUtils.trimToEmpty((String)supplier.get()));
    }

    private static void applyInteger(@NonNull Supplier<Integer> supplier, @NonNull Consumer<Integer> consumer) {
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        consumer.accept(supplier.get());
    }

    private static void applyBigDecimal(@NonNull Supplier<BigDecimal> supplier, @NonNull Consumer<BigDecimal> consumer) {
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        consumer.accept(supplier.get());
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public String getPositionNumber() {
        return this.positionNumber;
    }

    public BigDecimal getProduct() {
        return this.product;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getShortText() {
        return this.shortText;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public BigDecimal getPricePerUnit() {
        return this.pricePerUnit;
    }

    public BigDecimal getPriceAggregated() {
        return this.priceAggregated;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public void setSequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public void setPositionNumber(String positionNumber) {
        this.positionNumber = positionNumber;
    }

    public void setProduct(BigDecimal product) {
        this.product = product;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setShortText(String shortText) {
        this.shortText = shortText;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public void setPricePerUnit(BigDecimal pricePerUnit) {
        this.pricePerUnit = pricePerUnit;
    }

    public void setPriceAggregated(BigDecimal priceAggregated) {
        this.priceAggregated = priceAggregated;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InvoicePositionPrintRow)) {
            return false;
        }
        InvoicePositionPrintRow other = (InvoicePositionPrintRow)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$sequenceNumber = this.getSequenceNumber();
        Integer other$sequenceNumber = other.getSequenceNumber();
        if (this$sequenceNumber == null ? other$sequenceNumber != null : !((Object)this$sequenceNumber).equals(other$sequenceNumber)) {
            return false;
        }
        String this$referenceId = this.getReferenceId();
        String other$referenceId = other.getReferenceId();
        if (this$referenceId == null ? other$referenceId != null : !this$referenceId.equals(other$referenceId)) {
            return false;
        }
        String this$positionNumber = this.getPositionNumber();
        String other$positionNumber = other.getPositionNumber();
        if (this$positionNumber == null ? other$positionNumber != null : !this$positionNumber.equals(other$positionNumber)) {
            return false;
        }
        BigDecimal this$product = this.getProduct();
        BigDecimal other$product = other.getProduct();
        if (this$product == null ? other$product != null : !((Object)this$product).equals(other$product)) {
            return false;
        }
        String this$unit = this.getUnit();
        String other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
            return false;
        }
        String this$shortText = this.getShortText();
        String other$shortText = other.getShortText();
        if (this$shortText == null ? other$shortText != null : !this$shortText.equals(other$shortText)) {
            return false;
        }
        String this$remarks = this.getRemarks();
        String other$remarks = other.getRemarks();
        if (this$remarks == null ? other$remarks != null : !this$remarks.equals(other$remarks)) {
            return false;
        }
        BigDecimal this$pricePerUnit = this.getPricePerUnit();
        BigDecimal other$pricePerUnit = other.getPricePerUnit();
        if (this$pricePerUnit == null ? other$pricePerUnit != null : !((Object)this$pricePerUnit).equals(other$pricePerUnit)) {
            return false;
        }
        BigDecimal this$priceAggregated = this.getPriceAggregated();
        BigDecimal other$priceAggregated = other.getPriceAggregated();
        return !(this$priceAggregated == null ? other$priceAggregated != null : !((Object)this$priceAggregated).equals(other$priceAggregated));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InvoicePositionPrintRow;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $sequenceNumber = this.getSequenceNumber();
        result = result * 59 + ($sequenceNumber == null ? 43 : ((Object)$sequenceNumber).hashCode());
        String $referenceId = this.getReferenceId();
        result = result * 59 + ($referenceId == null ? 43 : $referenceId.hashCode());
        String $positionNumber = this.getPositionNumber();
        result = result * 59 + ($positionNumber == null ? 43 : $positionNumber.hashCode());
        BigDecimal $product = this.getProduct();
        result = result * 59 + ($product == null ? 43 : ((Object)$product).hashCode());
        String $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        String $shortText = this.getShortText();
        result = result * 59 + ($shortText == null ? 43 : $shortText.hashCode());
        String $remarks = this.getRemarks();
        result = result * 59 + ($remarks == null ? 43 : $remarks.hashCode());
        BigDecimal $pricePerUnit = this.getPricePerUnit();
        result = result * 59 + ($pricePerUnit == null ? 43 : ((Object)$pricePerUnit).hashCode());
        BigDecimal $priceAggregated = this.getPriceAggregated();
        result = result * 59 + ($priceAggregated == null ? 43 : ((Object)$priceAggregated).hashCode());
        return result;
    }

    public String toString() {
        return "InvoicePositionPrintRow(referenceId=" + this.getReferenceId() + ", sequenceNumber=" + this.getSequenceNumber() + ", positionNumber=" + this.getPositionNumber() + ", product=" + String.valueOf(this.getProduct()) + ", unit=" + this.getUnit() + ", shortText=" + this.getShortText() + ", remarks=" + this.getRemarks() + ", pricePerUnit=" + String.valueOf(this.getPricePerUnit()) + ", priceAggregated=" + String.valueOf(this.getPriceAggregated()) + ")";
    }
}

