/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.print;

import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.model.internal.pdfbox.EBooleanPrintOption;
import java.awt.Color;
import java.time.LocalDate;
import lombok.NonNull;

public abstract class PrintConfiguration {
    public static Iterable<EBooleanPrintOption> DEFAULT_BOOLEAN_PRINT_OPTIONS = ImmutableSet.of((Object)EBooleanPrintOption.FILL_UP_TABLE_ENABLED, (Object)EBooleanPrintOption.FREE_FROM_DEFECTS_CHECKED, (Object)EBooleanPrintOption.WORK_IS_ACCEPTED_CHECKED, (Object)EBooleanPrintOption.PRINT_OVERALL_VALUE_ENABLED);
    private final Color headerBgColor;
    private final Iterable<EBooleanPrintOption> booleanPrintOptions;
    private final LocalDate printDate;

    protected PrintConfiguration(@NonNull Color headerBgColor, @NonNull Iterable<EBooleanPrintOption> booleanPrintOptions, @NonNull LocalDate printDate) {
        if (headerBgColor == null) {
            throw new NullPointerException("headerBgColor is marked non-null but is null");
        }
        if (booleanPrintOptions == null) {
            throw new NullPointerException("booleanPrintOptions is marked non-null but is null");
        }
        if (printDate == null) {
            throw new NullPointerException("printDate is marked non-null but is null");
        }
        this.headerBgColor = headerBgColor;
        this.booleanPrintOptions = booleanPrintOptions;
        this.printDate = printDate;
    }

    public Color getHeaderBgColor() {
        return this.headerBgColor;
    }

    public Iterable<EBooleanPrintOption> getBooleanPrintOptions() {
        return this.booleanPrintOptions;
    }

    public LocalDate getPrintDate() {
        return this.printDate;
    }
}

