/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.measurement;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.compress.utils.Lists;

/*
 * Exception performing whole class analysis ignored.
 */
public class MeasurementPositionGroup {
    private boolean generated;
    @NonNull
    private Long id;
    @NonNull
    private String key;
    @NonNull
    private String shortText;
    @NonNull
    private String longText;
    @NonNull
    private Integer level;
    @NonNull
    private Map<String, MeasurementPositionGroup> children;
    @NonNull
    private List<MeasurementPosition> comments;
    @NonNull
    private List<MeasurementPosition> positions;

    @Nonnull
    public static MeasurementPositionGroup generated() {
        return MeasurementPositionGroup.create((boolean)true);
    }

    @Nonnull
    public static MeasurementPositionGroup natural() {
        return MeasurementPositionGroup.create((boolean)false);
    }

    @Nonnull
    private static MeasurementPositionGroup create(boolean generated) {
        MeasurementPositionGroup positionGroup = new MeasurementPositionGroup();
        positionGroup.setGenerated(generated);
        positionGroup.setChildren((Map)Maps.newHashMap());
        positionGroup.setComments((List)Lists.newArrayList());
        positionGroup.setPositions((List)Lists.newArrayList());
        return positionGroup;
    }

    @Nonnull
    public Iterable<MeasurementPosition> positions(boolean cascade) {
        Stream<MeasurementPositionGroup> positionGroupStream = cascade ? this.cascadedStream() : Stream.of(this);
        return (Iterable)positionGroupStream.flatMap(item -> item.getPositions().stream()).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public Stream<MeasurementPositionGroup> cascadedStream() {
        return Stream.concat(Stream.of(this), this.children.values().stream().flatMap(MeasurementPositionGroup::cascadedStream));
    }

    public boolean isEmpty() {
        return this.children.isEmpty() && this.positions.isEmpty() && this.comments.isEmpty();
    }

    public boolean isGenerated() {
        return this.generated;
    }

    @NonNull
    public Long getId() {
        return this.id;
    }

    @NonNull
    public String getKey() {
        return this.key;
    }

    @NonNull
    public String getShortText() {
        return this.shortText;
    }

    @NonNull
    public String getLongText() {
        return this.longText;
    }

    @NonNull
    public Integer getLevel() {
        return this.level;
    }

    @NonNull
    public Map<String, MeasurementPositionGroup> getChildren() {
        return this.children;
    }

    @NonNull
    public List<MeasurementPosition> getComments() {
        return this.comments;
    }

    @NonNull
    public List<MeasurementPosition> getPositions() {
        return this.positions;
    }

    public void setGenerated(boolean generated) {
        this.generated = generated;
    }

    public void setId(@NonNull Long id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    public void setKey(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.key = key;
    }

    public void setShortText(@NonNull String shortText) {
        if (shortText == null) {
            throw new NullPointerException("shortText is marked non-null but is null");
        }
        this.shortText = shortText;
    }

    public void setLongText(@NonNull String longText) {
        if (longText == null) {
            throw new NullPointerException("longText is marked non-null but is null");
        }
        this.longText = longText;
    }

    public void setLevel(@NonNull Integer level) {
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        this.level = level;
    }

    public void setChildren(@NonNull Map<String, MeasurementPositionGroup> children) {
        if (children == null) {
            throw new NullPointerException("children is marked non-null but is null");
        }
        this.children = children;
    }

    public void setComments(@NonNull List<MeasurementPosition> comments) {
        if (comments == null) {
            throw new NullPointerException("comments is marked non-null but is null");
        }
        this.comments = comments;
    }

    public void setPositions(@NonNull List<MeasurementPosition> positions) {
        if (positions == null) {
            throw new NullPointerException("positions is marked non-null but is null");
        }
        this.positions = positions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MeasurementPositionGroup)) {
            return false;
        }
        MeasurementPositionGroup other = (MeasurementPositionGroup)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isGenerated() != other.isGenerated()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$level = this.getLevel();
        Integer other$level = other.getLevel();
        if (this$level == null ? other$level != null : !((Object)this$level).equals(other$level)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$shortText = this.getShortText();
        String other$shortText = other.getShortText();
        if (this$shortText == null ? other$shortText != null : !this$shortText.equals(other$shortText)) {
            return false;
        }
        String this$longText = this.getLongText();
        String other$longText = other.getLongText();
        if (this$longText == null ? other$longText != null : !this$longText.equals(other$longText)) {
            return false;
        }
        Map this$children = this.getChildren();
        Map other$children = other.getChildren();
        if (this$children == null ? other$children != null : !((Object)this$children).equals(other$children)) {
            return false;
        }
        List this$comments = this.getComments();
        List other$comments = other.getComments();
        if (this$comments == null ? other$comments != null : !((Object)this$comments).equals(other$comments)) {
            return false;
        }
        List this$positions = this.getPositions();
        List other$positions = other.getPositions();
        return !(this$positions == null ? other$positions != null : !((Object)this$positions).equals(other$positions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MeasurementPositionGroup;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isGenerated() ? 79 : 97);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : ((Object)$level).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $shortText = this.getShortText();
        result = result * 59 + ($shortText == null ? 43 : $shortText.hashCode());
        String $longText = this.getLongText();
        result = result * 59 + ($longText == null ? 43 : $longText.hashCode());
        Map $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        List $comments = this.getComments();
        result = result * 59 + ($comments == null ? 43 : ((Object)$comments).hashCode());
        List $positions = this.getPositions();
        result = result * 59 + ($positions == null ? 43 : ((Object)$positions).hashCode());
        return result;
    }

    public String toString() {
        return "MeasurementPositionGroup(generated=" + this.isGenerated() + ", id=" + this.getId() + ", key=" + this.getKey() + ", shortText=" + this.getShortText() + ", longText=" + this.getLongText() + ", level=" + this.getLevel() + ", children=" + String.valueOf(this.getChildren()) + ", comments=" + String.valueOf(this.getComments()) + ", positions=" + String.valueOf(this.getPositions()) + ")";
    }
}

