/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.invoice;

import com.google.common.collect.ImmutableList;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import javax.annotation.Nonnull;
import lombok.NonNull;

public class CumulativePrintBucket {
    private final boolean optionCumulativePrint;
    private final boolean optionCumulativePrintConsiderRemarks;
    @NonNull
    private final Iterable<Invoice> cumulativeInvoices;
    @NonNull
    private final Iterable<Quotation> quotations;

    @Nonnull
    public static CumulativePrintBucket empty() {
        return new CumulativePrintBucket(false, false, (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of());
    }

    private CumulativePrintBucket(boolean optionCumulativePrint, boolean optionCumulativePrintConsiderRemarks, @NonNull Iterable<Invoice> cumulativeInvoices, @NonNull Iterable<Quotation> quotations) {
        if (cumulativeInvoices == null) {
            throw new NullPointerException("cumulativeInvoices is marked non-null but is null");
        }
        if (quotations == null) {
            throw new NullPointerException("quotations is marked non-null but is null");
        }
        this.optionCumulativePrint = optionCumulativePrint;
        this.optionCumulativePrintConsiderRemarks = optionCumulativePrintConsiderRemarks;
        this.cumulativeInvoices = cumulativeInvoices;
        this.quotations = quotations;
    }

    public static CumulativePrintBucket of(boolean optionCumulativePrint, boolean optionCumulativePrintConsiderRemarks, @NonNull Iterable<Invoice> cumulativeInvoices, @NonNull Iterable<Quotation> quotations) {
        if (cumulativeInvoices == null) {
            throw new NullPointerException("cumulativeInvoices is marked non-null but is null");
        }
        if (quotations == null) {
            throw new NullPointerException("quotations is marked non-null but is null");
        }
        return new CumulativePrintBucket(optionCumulativePrint, optionCumulativePrintConsiderRemarks, cumulativeInvoices, quotations);
    }

    public boolean isOptionCumulativePrint() {
        return this.optionCumulativePrint;
    }

    public boolean isOptionCumulativePrintConsiderRemarks() {
        return this.optionCumulativePrintConsiderRemarks;
    }

    @NonNull
    public Iterable<Invoice> getCumulativeInvoices() {
        return this.cumulativeInvoices;
    }

    @NonNull
    public Iterable<Quotation> getQuotations() {
        return this.quotations;
    }
}

