/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.history;

import com.google.common.collect.ImmutableMap;
import de.qfm.erp.service.model.internal.history.HistoryField;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EMeasurementHistoryField implements HistoryField
{
    UNKNOWN("", "n/a", false),
    NOTE("", "genericNote", false),
    MEASUREMENT_NUMBER("", "measurementNumber", false),
    ASSIGNED_USER__ID("", "assignedUserId", false),
    ASSIGNED_USER__USERNAME("", "assignedUserName", false),
    ASSIGNED_USER__FULL_NAME("", "assignedFullName", false),
    QUOTATION__ID("", "quotationId", false),
    QUOTATION__QUOTATION_NUMBER("", "quotationNumber", false),
    INVOICE__ID("", "invoiceId", false),
    INVOICE__INVOICE_NUMBER("", "invoiceNumber", false),
    MEASUREMENT_STATE__MEASUREMENT_STATE("", "measurementState", false, "enum.measurement_state."),
    MEASUREMENT_TYPE("", "measurementType", false, "enum.measurement_type."),
    MEASUREMENT_VIEW_TYPE("", "measurementViewType", false, "enum.measurement_view_type."),
    REMARKS("", "remarks", false),
    REMARKS_INTERNAL("", "remarksInternal", false),
    CONSTRUCTION_SITE("", "constructionSite", false),
    PERSON_RESPONSIBLE_AT_CUSTOMER("", "personResponsibleAtCustomer", false),
    CUSTOMER_AREA("", "customerArea", false),
    PROJECT_EXECUTION_START_DATE("", "projectExecutionStartDate", false),
    PROJECT_EXECUTION_END_DATE("", "projectExecutionEndDate", false),
    ACCOUNTING_MONTH("", "accountingMonth", false),
    ACCOUNTING_MONTH_PLANNED("", "accountingMonthPlanned", false),
    SQUAD_WAGE_OVERALL("", "squadWageOverall", false),
    VALUE_OVERALL("", "valueOverall", true),
    COMPANY_WAGE_OVERALL("", "companyWageOverall", true),
    MATERIAL_PURCHASE_PRICE_OVERALL("", "materialPurchasePriceOverall", true),
    RELEASE_ORDER__NAME("releaseOrder", "name", false),
    RELEASE_ORDER__ORDER_NUMBER("releaseOrder", "orderNumber", false),
    RELEASE_ORDER__PSS_RO__ID("releaseOrder", "pssReleaseOrderId", false),
    RELEASE_ORDER__PSS_RO__STATE("releaseOrder", "pssReleaseOrderState", false),
    MEASUREMENT_POSITION__SPN("position", "surrogatePositionNumber", false),
    MEASUREMENT_POSITION__SHORT_TEXT("position", "shortText", false),
    MEASUREMENT_POSITION__AMOUNT("position", "amount", false),
    MEASUREMENT_POSITION__FACTOR1("position", "factor1", false),
    MEASUREMENT_POSITION__FACTOR2("position", "factor2", false),
    MEASUREMENT_POSITION__FACTOR3("position", "factor3", false),
    MEASUREMENT_POSITION__REMARKS("position", "remarks", false);

    private final String fieldPrefix;
    private final String fieldName;
    private final boolean requiresAllAttributesVisible;
    private final String translationPrefix;
    private static final Map<String, EMeasurementHistoryField> FIELD_MAPPING;

    private EMeasurementHistoryField(String fieldPrefix, String fieldName, boolean requiresAllAttributesVisible) {
        this.fieldPrefix = fieldPrefix;
        this.fieldName = fieldName;
        this.requiresAllAttributesVisible = requiresAllAttributesVisible;
        this.translationPrefix = "";
    }

    private EMeasurementHistoryField(String fieldPrefix, String fieldName, boolean requiresAllAttributesVisible, String translationPrefix) {
        this.fieldPrefix = fieldPrefix;
        this.fieldName = fieldName;
        this.requiresAllAttributesVisible = requiresAllAttributesVisible;
        this.translationPrefix = translationPrefix;
    }

    public boolean isRequireAllAttributesVisible() {
        return this.requiresAllAttributesVisible;
    }

    public boolean isTranslatable() {
        return StringUtils.isNotBlank((CharSequence)this.translationPrefix);
    }

    @Nonnull
    public String translationPrefix() {
        return StringUtils.trimToEmpty((String)this.translationPrefix);
    }

    @Nonnull
    public String fieldName() {
        return this.fieldName;
    }

    @Nonnull
    public String fieldPrefix() {
        return StringUtils.trimToEmpty((String)this.fieldPrefix);
    }

    @Nonnull
    public String messageCode() {
        return "measurement." + EMeasurementHistoryField.key((EMeasurementHistoryField)this);
    }

    @Nonnull
    private static String key(@NonNull EMeasurementHistoryField value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return EMeasurementHistoryField.key((String)value.name());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    private static String lookupKey(@NonNull String fieldPrefix, @NonNull String fieldName) {
        if (fieldPrefix == null) {
            throw new NullPointerException("fieldPrefix is marked non-null but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)fieldPrefix)) {
            return StringUtils.lowerCase((String)fieldName);
        }
        return String.format("%s.%s", StringUtils.lowerCase((String)fieldPrefix), StringUtils.lowerCase((String)fieldName));
    }

    @Nonnull
    public static EMeasurementHistoryField lookup(@NonNull String fieldPrefix, @NonNull String fieldName) {
        if (fieldPrefix == null) {
            throw new NullPointerException("fieldPrefix is marked non-null but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        String lookupKey = EMeasurementHistoryField.lookupKey((String)fieldPrefix, (String)fieldName);
        return FIELD_MAPPING.getOrDefault(lookupKey, UNKNOWN);
    }

    @Nonnull
    public static EMeasurementHistoryField lookup(@NonNull String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        String lookupKey = EMeasurementHistoryField.lookupKey((String)"", (String)fieldName);
        return FIELD_MAPPING.getOrDefault(lookupKey, UNKNOWN);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Arrays.stream(EMeasurementHistoryField.values()).forEach(item -> builder.put((Object)EMeasurementHistoryField.lookupKey((String)StringUtils.trimToEmpty((String)item.fieldPrefix), (String)StringUtils.trimToEmpty((String)item.fieldName)), item));
        FIELD_MAPPING = builder.build();
    }
}

