/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.csv;

import com.google.common.collect.ImmutableMap;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.service.validator.Validator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum ECsvExportType {
    STROMNETZ_BERLIN,
    TELEKOM;

    private static final Map<String, ECsvExportType> LOOKUP;

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static ECsvExportType lookup(@NonNull String candidate, @NonNull ECsvExportType defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return ECsvExportType.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<ECsvExportType> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = ECsvExportType.key((String)candidate);
        return Optional.ofNullable((ECsvExportType)LOOKUP.get(key));
    }

    @NonNull
    public static ECsvExportType lookupFailing(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = ECsvExportType.key((String)candidate);
        ECsvExportType measurementState = (ECsvExportType)LOOKUP.get(key);
        if (null == measurementState) {
            throw Validator.throwEnumException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.MEASUREMENT_COPY_MODE), (String)candidate, ECsvExportType.class, ECsvExportType::allowedKeys);
        }
        return measurementState;
    }

    @Nonnull
    public String key() {
        return ECsvExportType.key((ECsvExportType)this);
    }

    @Nonnull
    private static String key(@NonNull ECsvExportType value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return ECsvExportType.key((String)value.name());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ECsvExportType value : ECsvExportType.values()) {
            String key = ECsvExportType.key((ECsvExportType)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
    }
}

