/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.external.psx;

import de.qfm.erp.common.response.user.JWTTokenResponse;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.specification.RequestSpecification;
import java.time.LocalDateTime;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import lombok.NonNull;

/*
 * Exception performing whole class analysis ignored.
 */
public class PsxAuthContext {
    private final boolean authenticated;
    @NonNull
    private final String username;
    @NonNull
    private final String password;
    @NonNull
    private final JWTTokenResponse token;
    @NonNull
    private final Supplier<RequestSpecification> requestSpecification;

    @Nonnull
    public static PsxAuthContext success(@NonNull String username, @NonNull String password, @NonNull JWTTokenResponse token, @NonNull Supplier<RequestSpecification> requestSpecification) {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (requestSpecification == null) {
            throw new NullPointerException("requestSpecification is marked non-null but is null");
        }
        return PsxAuthContext.of((boolean)true, (String)username, (String)password, (JWTTokenResponse)token, requestSpecification);
    }

    @Nonnull
    public static PsxAuthContext empty() {
        return PsxAuthContext.of((boolean)false, (String)"", (String)"", (JWTTokenResponse)new JWTTokenResponse(), RestAssured::given);
    }

    public boolean isAuthenticated() {
        String accessToken = this.token.getAccessToken();
        LocalDateTime accessTokenValidUntil = this.token.getAccessTokenValidUntil();
        return this.authenticated && accessToken != null && accessTokenValidUntil != null && accessTokenValidUntil.isAfter(LocalDateTime.now().plusSeconds(30L));
    }

    @Nonnull
    public RequestSpecification request() {
        if (this.isAuthenticated()) {
            return this.authorizedRequest();
        }
        return this.unauthorizedRequest();
    }

    @Nonnull
    public RequestSpecification authorizedRequest() {
        String accessToken = this.token.getAccessToken();
        return ((RequestSpecification)this.requestSpecification.get()).accept(ContentType.JSON).header("Authorization", (Object)("Bearer " + accessToken), new Object[0]);
    }

    @Nonnull
    public RequestSpecification unauthorizedRequest() {
        return ((RequestSpecification)this.requestSpecification.get()).accept(ContentType.JSON);
    }

    private PsxAuthContext(boolean authenticated, @NonNull String username, @NonNull String password, @NonNull JWTTokenResponse token, @NonNull Supplier<RequestSpecification> requestSpecification) {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (requestSpecification == null) {
            throw new NullPointerException("requestSpecification is marked non-null but is null");
        }
        this.authenticated = authenticated;
        this.username = username;
        this.password = password;
        this.token = token;
        this.requestSpecification = requestSpecification;
    }

    public static PsxAuthContext of(boolean authenticated, @NonNull String username, @NonNull String password, @NonNull JWTTokenResponse token, @NonNull Supplier<RequestSpecification> requestSpecification) {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (requestSpecification == null) {
            throw new NullPointerException("requestSpecification is marked non-null but is null");
        }
        return new PsxAuthContext(authenticated, username, password, token, requestSpecification);
    }

    @NonNull
    public String getUsername() {
        return this.username;
    }

    @NonNull
    public String getPassword() {
        return this.password;
    }

    @NonNull
    public JWTTokenResponse getToken() {
        return this.token;
    }

    @NonNull
    public Supplier<RequestSpecification> getRequestSpecification() {
        return this.requestSpecification;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PsxAuthContext)) {
            return false;
        }
        PsxAuthContext other = (PsxAuthContext)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isAuthenticated() != other.isAuthenticated()) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        JWTTokenResponse this$token = this.getToken();
        JWTTokenResponse other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        Supplier this$requestSpecification = this.getRequestSpecification();
        Supplier other$requestSpecification = other.getRequestSpecification();
        return !(this$requestSpecification == null ? other$requestSpecification != null : !this$requestSpecification.equals(other$requestSpecification));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PsxAuthContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAuthenticated() ? 79 : 97);
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        JWTTokenResponse $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        Supplier $requestSpecification = this.getRequestSpecification();
        result = result * 59 + ($requestSpecification == null ? 43 : $requestSpecification.hashCode());
        return result;
    }

    public String toString() {
        return "PsxAuthContext(authenticated=" + this.isAuthenticated() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", token=" + String.valueOf(this.getToken()) + ", requestSpecification=" + String.valueOf(this.getRequestSpecification()) + ")";
    }
}

