/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.external.psx;

import de.qfm.erp.service.model.external.psx.ExtPsxUpdateRequest;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Nullable;

public class ExtPsxReleaseOrderUpdateRequest
extends ExtPsxUpdateRequest {
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="Id of a Release Order")
    @Nullable
    private Long id;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="Reference Id Name of a Release Order")
    @Size(max=250)
    private @Size(max=250) String referenceId;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="Type of a Release Order", allowableValues={"STANDARD", "INCIDENT"})
    @Size(max=250)
    private @Size(max=250) String releaseOrderType;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="date/time when the release order was imported")
    @Nullable
    private LocalDateTime receiveDateTime;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="date/time when the release order ended")
    @Nullable
    private LocalDateTime endDateTime;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="release order order number")
    @NotNull
    @Size(max=250)
    private @NotNull @Size(max=250) String orderNumber;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="release order project number")
    @NotNull
    @Size(max=250)
    private @NotNull @Size(max=250) String projectNumber;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="release order order value")
    @Nullable
    private BigDecimal orderValue;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="release order remarks")
    @NotNull
    @Size(max=4000)
    private @NotNull @Size(max=4000) String remarks;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="state.name", allowableValues={"PLANNED", "NEW", "IN_PROGRESS", "ARCHIVED", "CANCELLED", "DELETED"})
    @Size(max=250)
    @NotNull
    private @Size(max=250) @NotNull String releaseOrderStateName;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="contact person - on site (not related to contact person of customer)")
    @NotNull
    @Size(max=250)
    private @NotNull @Size(max=250) String contactPersonOnSite;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="the stage ROG assigned to this release order")
    @NotNull
    private Long stageGroupId;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="responsible users")
    @NotNull
    private List<Long> responsibleUserIds;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="appointments related to release order")
    @NotNull
    private List<Long> appointmentIds;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="construction sites related to release order")
    @NotNull
    private List<Long> constructionSiteIds;

    @Nullable
    public Long getId() {
        return this.id;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public String getReleaseOrderType() {
        return this.releaseOrderType;
    }

    @Nullable
    public LocalDateTime getReceiveDateTime() {
        return this.receiveDateTime;
    }

    @Nullable
    public LocalDateTime getEndDateTime() {
        return this.endDateTime;
    }

    public String getOrderNumber() {
        return this.orderNumber;
    }

    public String getProjectNumber() {
        return this.projectNumber;
    }

    @Nullable
    public BigDecimal getOrderValue() {
        return this.orderValue;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public String getReleaseOrderStateName() {
        return this.releaseOrderStateName;
    }

    public String getContactPersonOnSite() {
        return this.contactPersonOnSite;
    }

    public Long getStageGroupId() {
        return this.stageGroupId;
    }

    public List<Long> getResponsibleUserIds() {
        return this.responsibleUserIds;
    }

    public List<Long> getAppointmentIds() {
        return this.appointmentIds;
    }

    public List<Long> getConstructionSiteIds() {
        return this.constructionSiteIds;
    }

    public void setId(@Nullable Long id) {
        this.id = id;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public void setReleaseOrderType(String releaseOrderType) {
        this.releaseOrderType = releaseOrderType;
    }

    public void setReceiveDateTime(@Nullable LocalDateTime receiveDateTime) {
        this.receiveDateTime = receiveDateTime;
    }

    public void setEndDateTime(@Nullable LocalDateTime endDateTime) {
        this.endDateTime = endDateTime;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public void setProjectNumber(String projectNumber) {
        this.projectNumber = projectNumber;
    }

    public void setOrderValue(@Nullable BigDecimal orderValue) {
        this.orderValue = orderValue;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public void setReleaseOrderStateName(String releaseOrderStateName) {
        this.releaseOrderStateName = releaseOrderStateName;
    }

    public void setContactPersonOnSite(String contactPersonOnSite) {
        this.contactPersonOnSite = contactPersonOnSite;
    }

    public void setStageGroupId(Long stageGroupId) {
        this.stageGroupId = stageGroupId;
    }

    public void setResponsibleUserIds(List<Long> responsibleUserIds) {
        this.responsibleUserIds = responsibleUserIds;
    }

    public void setAppointmentIds(List<Long> appointmentIds) {
        this.appointmentIds = appointmentIds;
    }

    public void setConstructionSiteIds(List<Long> constructionSiteIds) {
        this.constructionSiteIds = constructionSiteIds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExtPsxReleaseOrderUpdateRequest)) {
            return false;
        }
        ExtPsxReleaseOrderUpdateRequest other = (ExtPsxReleaseOrderUpdateRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$stageGroupId = this.getStageGroupId();
        Long other$stageGroupId = other.getStageGroupId();
        if (this$stageGroupId == null ? other$stageGroupId != null : !((Object)this$stageGroupId).equals(other$stageGroupId)) {
            return false;
        }
        String this$referenceId = this.getReferenceId();
        String other$referenceId = other.getReferenceId();
        if (this$referenceId == null ? other$referenceId != null : !this$referenceId.equals(other$referenceId)) {
            return false;
        }
        String this$releaseOrderType = this.getReleaseOrderType();
        String other$releaseOrderType = other.getReleaseOrderType();
        if (this$releaseOrderType == null ? other$releaseOrderType != null : !this$releaseOrderType.equals(other$releaseOrderType)) {
            return false;
        }
        LocalDateTime this$receiveDateTime = this.getReceiveDateTime();
        LocalDateTime other$receiveDateTime = other.getReceiveDateTime();
        if (this$receiveDateTime == null ? other$receiveDateTime != null : !((Object)this$receiveDateTime).equals(other$receiveDateTime)) {
            return false;
        }
        LocalDateTime this$endDateTime = this.getEndDateTime();
        LocalDateTime other$endDateTime = other.getEndDateTime();
        if (this$endDateTime == null ? other$endDateTime != null : !((Object)this$endDateTime).equals(other$endDateTime)) {
            return false;
        }
        String this$orderNumber = this.getOrderNumber();
        String other$orderNumber = other.getOrderNumber();
        if (this$orderNumber == null ? other$orderNumber != null : !this$orderNumber.equals(other$orderNumber)) {
            return false;
        }
        String this$projectNumber = this.getProjectNumber();
        String other$projectNumber = other.getProjectNumber();
        if (this$projectNumber == null ? other$projectNumber != null : !this$projectNumber.equals(other$projectNumber)) {
            return false;
        }
        BigDecimal this$orderValue = this.getOrderValue();
        BigDecimal other$orderValue = other.getOrderValue();
        if (this$orderValue == null ? other$orderValue != null : !((Object)this$orderValue).equals(other$orderValue)) {
            return false;
        }
        String this$remarks = this.getRemarks();
        String other$remarks = other.getRemarks();
        if (this$remarks == null ? other$remarks != null : !this$remarks.equals(other$remarks)) {
            return false;
        }
        String this$releaseOrderStateName = this.getReleaseOrderStateName();
        String other$releaseOrderStateName = other.getReleaseOrderStateName();
        if (this$releaseOrderStateName == null ? other$releaseOrderStateName != null : !this$releaseOrderStateName.equals(other$releaseOrderStateName)) {
            return false;
        }
        String this$contactPersonOnSite = this.getContactPersonOnSite();
        String other$contactPersonOnSite = other.getContactPersonOnSite();
        if (this$contactPersonOnSite == null ? other$contactPersonOnSite != null : !this$contactPersonOnSite.equals(other$contactPersonOnSite)) {
            return false;
        }
        List this$responsibleUserIds = this.getResponsibleUserIds();
        List other$responsibleUserIds = other.getResponsibleUserIds();
        if (this$responsibleUserIds == null ? other$responsibleUserIds != null : !((Object)this$responsibleUserIds).equals(other$responsibleUserIds)) {
            return false;
        }
        List this$appointmentIds = this.getAppointmentIds();
        List other$appointmentIds = other.getAppointmentIds();
        if (this$appointmentIds == null ? other$appointmentIds != null : !((Object)this$appointmentIds).equals(other$appointmentIds)) {
            return false;
        }
        List this$constructionSiteIds = this.getConstructionSiteIds();
        List other$constructionSiteIds = other.getConstructionSiteIds();
        return !(this$constructionSiteIds == null ? other$constructionSiteIds != null : !((Object)this$constructionSiteIds).equals(other$constructionSiteIds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExtPsxReleaseOrderUpdateRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $stageGroupId = this.getStageGroupId();
        result = result * 59 + ($stageGroupId == null ? 43 : ((Object)$stageGroupId).hashCode());
        String $referenceId = this.getReferenceId();
        result = result * 59 + ($referenceId == null ? 43 : $referenceId.hashCode());
        String $releaseOrderType = this.getReleaseOrderType();
        result = result * 59 + ($releaseOrderType == null ? 43 : $releaseOrderType.hashCode());
        LocalDateTime $receiveDateTime = this.getReceiveDateTime();
        result = result * 59 + ($receiveDateTime == null ? 43 : ((Object)$receiveDateTime).hashCode());
        LocalDateTime $endDateTime = this.getEndDateTime();
        result = result * 59 + ($endDateTime == null ? 43 : ((Object)$endDateTime).hashCode());
        String $orderNumber = this.getOrderNumber();
        result = result * 59 + ($orderNumber == null ? 43 : $orderNumber.hashCode());
        String $projectNumber = this.getProjectNumber();
        result = result * 59 + ($projectNumber == null ? 43 : $projectNumber.hashCode());
        BigDecimal $orderValue = this.getOrderValue();
        result = result * 59 + ($orderValue == null ? 43 : ((Object)$orderValue).hashCode());
        String $remarks = this.getRemarks();
        result = result * 59 + ($remarks == null ? 43 : $remarks.hashCode());
        String $releaseOrderStateName = this.getReleaseOrderStateName();
        result = result * 59 + ($releaseOrderStateName == null ? 43 : $releaseOrderStateName.hashCode());
        String $contactPersonOnSite = this.getContactPersonOnSite();
        result = result * 59 + ($contactPersonOnSite == null ? 43 : $contactPersonOnSite.hashCode());
        List $responsibleUserIds = this.getResponsibleUserIds();
        result = result * 59 + ($responsibleUserIds == null ? 43 : ((Object)$responsibleUserIds).hashCode());
        List $appointmentIds = this.getAppointmentIds();
        result = result * 59 + ($appointmentIds == null ? 43 : ((Object)$appointmentIds).hashCode());
        List $constructionSiteIds = this.getConstructionSiteIds();
        result = result * 59 + ($constructionSiteIds == null ? 43 : ((Object)$constructionSiteIds).hashCode());
        return result;
    }

    public String toString() {
        return "ExtPsxReleaseOrderUpdateRequest(id=" + this.getId() + ", referenceId=" + this.getReferenceId() + ", releaseOrderType=" + this.getReleaseOrderType() + ", receiveDateTime=" + String.valueOf(this.getReceiveDateTime()) + ", endDateTime=" + String.valueOf(this.getEndDateTime()) + ", orderNumber=" + this.getOrderNumber() + ", projectNumber=" + this.getProjectNumber() + ", orderValue=" + String.valueOf(this.getOrderValue()) + ", remarks=" + this.getRemarks() + ", releaseOrderStateName=" + this.getReleaseOrderStateName() + ", contactPersonOnSite=" + this.getContactPersonOnSite() + ", stageGroupId=" + this.getStageGroupId() + ", responsibleUserIds=" + String.valueOf(this.getResponsibleUserIds()) + ", appointmentIds=" + String.valueOf(this.getAppointmentIds()) + ", constructionSiteIds=" + String.valueOf(this.getConstructionSiteIds()) + ")";
    }
}

