/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.external.psx;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;

public class ExtPsxNotifyResponse {
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, accessMode=Schema.AccessMode.READ_ONLY, description="HTTP 200 IS OK / true", allowableValues={"true", "false"})
    private boolean success;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, accessMode=Schema.AccessMode.READ_ONLY, description="The Entity ID of the DB entity")
    private Long entityId;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, accessMode=Schema.AccessMode.READ_ONLY, description="The Entity Type of the Origin within PSX", allowableValues={"PROJECT_TEAM", "ENTITY", "STAGE", "PROJECT"})
    @NotBlank
    @Size(max=250)
    private @NotBlank @Size(max=250) String entityType;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, accessMode=Schema.AccessMode.READ_ONLY, description="Origin Id for the Notify Entity (PSX.*.referenceId)", allowableValues={"PROJECT_TEAM", "ENTITY", "STAGE", "PROJECT"})
    @NotBlank
    @Size(max=250)
    private @NotBlank @Size(max=250) String entityReferenceId;

    private ExtPsxNotifyResponse(boolean success, Long entityId, String entityType, String entityReferenceId) {
        this.success = success;
        this.entityId = entityId;
        this.entityType = entityType;
        this.entityReferenceId = entityReferenceId;
    }

    public static ExtPsxNotifyResponse of(boolean success, Long entityId, String entityType, String entityReferenceId) {
        return new ExtPsxNotifyResponse(success, entityId, entityType, entityReferenceId);
    }

    public ExtPsxNotifyResponse() {
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Long getEntityId() {
        return this.entityId;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getEntityReferenceId() {
        return this.entityReferenceId;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setEntityId(Long entityId) {
        this.entityId = entityId;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public void setEntityReferenceId(String entityReferenceId) {
        this.entityReferenceId = entityReferenceId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExtPsxNotifyResponse)) {
            return false;
        }
        ExtPsxNotifyResponse other = (ExtPsxNotifyResponse)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        Long this$entityId = this.getEntityId();
        Long other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !((Object)this$entityId).equals(other$entityId)) {
            return false;
        }
        String this$entityType = this.getEntityType();
        String other$entityType = other.getEntityType();
        if (this$entityType == null ? other$entityType != null : !this$entityType.equals(other$entityType)) {
            return false;
        }
        String this$entityReferenceId = this.getEntityReferenceId();
        String other$entityReferenceId = other.getEntityReferenceId();
        return !(this$entityReferenceId == null ? other$entityReferenceId != null : !this$entityReferenceId.equals(other$entityReferenceId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExtPsxNotifyResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        Long $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : ((Object)$entityId).hashCode());
        String $entityType = this.getEntityType();
        result = result * 59 + ($entityType == null ? 43 : $entityType.hashCode());
        String $entityReferenceId = this.getEntityReferenceId();
        result = result * 59 + ($entityReferenceId == null ? 43 : $entityReferenceId.hashCode());
        return result;
    }

    public String toString() {
        return "ExtPsxNotifyResponse(success=" + this.isSuccess() + ", entityId=" + this.getEntityId() + ", entityType=" + this.getEntityType() + ", entityReferenceId=" + this.getEntityReferenceId() + ")";
    }
}

