/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.external.psx;

import de.qfm.erp.service.model.external.psx.ExtPsxUpdateRequest;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Nullable;

public class ExtPsxConstructionSiteUpdateRequest
extends ExtPsxUpdateRequest {
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="Id of a Release Order")
    @Nullable
    private Long id;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="Reference Id Name of a Release Order")
    @Nullable
    @Size(max=250)
    private @Size(max=250) String referenceId;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="construction site project number")
    @Nullable
    @Size(max=250)
    private @Size(max=250) String projectNumber;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="general description")
    @NotNull
    @Size(max=4000)
    private @NotNull @Size(max=4000) String generalDescription;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="procedure description")
    @NotNull
    @Size(max=4000)
    private @NotNull @Size(max=4000) String procedureDescription;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="street")
    @NotNull
    @Size(max=250)
    private @NotNull @Size(max=250) String street;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="street no")
    @NotNull
    @Size(max=50)
    private @NotNull @Size(max=50) String streetNo;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="zip code")
    @NotNull
    @Size(max=50)
    private @NotNull @Size(max=50) String zipCode;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="city")
    @NotNull
    @Size(max=250)
    private @NotNull @Size(max=250) String city;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="berlin district", allowableValues={"MITTE", "FRIEDRICHSHAIN_KREUZBERG", "PANKOW", "CHARLOTTENBURG_WILMERSDORF", "SPANDAU", "STEGLITZ_ZEHLENDORF", "TEMPELHOF_SCHOENEBERG", "NEUKOELLN", "TREPTOW_KOEPENICK", "MARZAHN_HELLERSDORF", "LICHTENBERG", "REINICKENDORF"})
    @NotNull
    @Size(max=250)
    private @NotNull @Size(max=250) String berlinDistrict;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="start of work planned date/time")
    private LocalDateTime startOfWorkPlannedDateTime;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="end of work planned date/time")
    private LocalDateTime endOfWorkPlannedDateTime;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="start of work as-is date/time")
    private LocalDateTime startOfWorkAsIsDateTime;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="end of work as-is date/time")
    private LocalDateTime endOfWorkAsIsDateTime;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="custom date/time 1")
    private LocalDateTime customDateTime1;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="custom date/time 2")
    private LocalDateTime customDateTime2;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="Contact Person OnSite")
    @Size(max=250)
    private @Size(max=250) String contactPersonOnSite;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="Contact Person OnSite Phone")
    @Size(max=250)
    private @Size(max=250) String contactPersonOnSitePhone;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="Contact Person OnSite Mail")
    @Size(max=250)
    private @Size(max=250) String contactPersonOnSiteMail;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="state.name", allowableValues={"PLANNED", "NEW", "IN_PROGRESS", "OUTAGE", "FINISHED", "SENT", "CANCELLED", "ARCHIVED", "DELETED"})
    @Size(max=250)
    private @Size(max=250) String constructionSiteStateName;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="executing company Id")
    private Long executingCompanyId;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="release order id")
    private Long releaseOrderId;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="contact person Ids")
    private List<Long> contactPersonIds;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="user assigned Ids")
    private List<Long> userAssignedIds;
    @Schema(accessMode=Schema.AccessMode.READ_WRITE, description="user involved Ids")
    private List<Long> userInvolvedIds;

    @Nullable
    public Long getId() {
        return this.id;
    }

    @Nullable
    public String getReferenceId() {
        return this.referenceId;
    }

    @Nullable
    public String getProjectNumber() {
        return this.projectNumber;
    }

    public String getGeneralDescription() {
        return this.generalDescription;
    }

    public String getProcedureDescription() {
        return this.procedureDescription;
    }

    public String getStreet() {
        return this.street;
    }

    public String getStreetNo() {
        return this.streetNo;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public String getCity() {
        return this.city;
    }

    public String getBerlinDistrict() {
        return this.berlinDistrict;
    }

    public LocalDateTime getStartOfWorkPlannedDateTime() {
        return this.startOfWorkPlannedDateTime;
    }

    public LocalDateTime getEndOfWorkPlannedDateTime() {
        return this.endOfWorkPlannedDateTime;
    }

    public LocalDateTime getStartOfWorkAsIsDateTime() {
        return this.startOfWorkAsIsDateTime;
    }

    public LocalDateTime getEndOfWorkAsIsDateTime() {
        return this.endOfWorkAsIsDateTime;
    }

    public LocalDateTime getCustomDateTime1() {
        return this.customDateTime1;
    }

    public LocalDateTime getCustomDateTime2() {
        return this.customDateTime2;
    }

    public String getContactPersonOnSite() {
        return this.contactPersonOnSite;
    }

    public String getContactPersonOnSitePhone() {
        return this.contactPersonOnSitePhone;
    }

    public String getContactPersonOnSiteMail() {
        return this.contactPersonOnSiteMail;
    }

    public String getConstructionSiteStateName() {
        return this.constructionSiteStateName;
    }

    public Long getExecutingCompanyId() {
        return this.executingCompanyId;
    }

    public Long getReleaseOrderId() {
        return this.releaseOrderId;
    }

    public List<Long> getContactPersonIds() {
        return this.contactPersonIds;
    }

    public List<Long> getUserAssignedIds() {
        return this.userAssignedIds;
    }

    public List<Long> getUserInvolvedIds() {
        return this.userInvolvedIds;
    }

    public void setId(@Nullable Long id) {
        this.id = id;
    }

    public void setReferenceId(@Nullable String referenceId) {
        this.referenceId = referenceId;
    }

    public void setProjectNumber(@Nullable String projectNumber) {
        this.projectNumber = projectNumber;
    }

    public void setGeneralDescription(String generalDescription) {
        this.generalDescription = generalDescription;
    }

    public void setProcedureDescription(String procedureDescription) {
        this.procedureDescription = procedureDescription;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public void setStreetNo(String streetNo) {
        this.streetNo = streetNo;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public void setBerlinDistrict(String berlinDistrict) {
        this.berlinDistrict = berlinDistrict;
    }

    public void setStartOfWorkPlannedDateTime(LocalDateTime startOfWorkPlannedDateTime) {
        this.startOfWorkPlannedDateTime = startOfWorkPlannedDateTime;
    }

    public void setEndOfWorkPlannedDateTime(LocalDateTime endOfWorkPlannedDateTime) {
        this.endOfWorkPlannedDateTime = endOfWorkPlannedDateTime;
    }

    public void setStartOfWorkAsIsDateTime(LocalDateTime startOfWorkAsIsDateTime) {
        this.startOfWorkAsIsDateTime = startOfWorkAsIsDateTime;
    }

    public void setEndOfWorkAsIsDateTime(LocalDateTime endOfWorkAsIsDateTime) {
        this.endOfWorkAsIsDateTime = endOfWorkAsIsDateTime;
    }

    public void setCustomDateTime1(LocalDateTime customDateTime1) {
        this.customDateTime1 = customDateTime1;
    }

    public void setCustomDateTime2(LocalDateTime customDateTime2) {
        this.customDateTime2 = customDateTime2;
    }

    public void setContactPersonOnSite(String contactPersonOnSite) {
        this.contactPersonOnSite = contactPersonOnSite;
    }

    public void setContactPersonOnSitePhone(String contactPersonOnSitePhone) {
        this.contactPersonOnSitePhone = contactPersonOnSitePhone;
    }

    public void setContactPersonOnSiteMail(String contactPersonOnSiteMail) {
        this.contactPersonOnSiteMail = contactPersonOnSiteMail;
    }

    public void setConstructionSiteStateName(String constructionSiteStateName) {
        this.constructionSiteStateName = constructionSiteStateName;
    }

    public void setExecutingCompanyId(Long executingCompanyId) {
        this.executingCompanyId = executingCompanyId;
    }

    public void setReleaseOrderId(Long releaseOrderId) {
        this.releaseOrderId = releaseOrderId;
    }

    public void setContactPersonIds(List<Long> contactPersonIds) {
        this.contactPersonIds = contactPersonIds;
    }

    public void setUserAssignedIds(List<Long> userAssignedIds) {
        this.userAssignedIds = userAssignedIds;
    }

    public void setUserInvolvedIds(List<Long> userInvolvedIds) {
        this.userInvolvedIds = userInvolvedIds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExtPsxConstructionSiteUpdateRequest)) {
            return false;
        }
        ExtPsxConstructionSiteUpdateRequest other = (ExtPsxConstructionSiteUpdateRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$executingCompanyId = this.getExecutingCompanyId();
        Long other$executingCompanyId = other.getExecutingCompanyId();
        if (this$executingCompanyId == null ? other$executingCompanyId != null : !((Object)this$executingCompanyId).equals(other$executingCompanyId)) {
            return false;
        }
        Long this$releaseOrderId = this.getReleaseOrderId();
        Long other$releaseOrderId = other.getReleaseOrderId();
        if (this$releaseOrderId == null ? other$releaseOrderId != null : !((Object)this$releaseOrderId).equals(other$releaseOrderId)) {
            return false;
        }
        String this$referenceId = this.getReferenceId();
        String other$referenceId = other.getReferenceId();
        if (this$referenceId == null ? other$referenceId != null : !this$referenceId.equals(other$referenceId)) {
            return false;
        }
        String this$projectNumber = this.getProjectNumber();
        String other$projectNumber = other.getProjectNumber();
        if (this$projectNumber == null ? other$projectNumber != null : !this$projectNumber.equals(other$projectNumber)) {
            return false;
        }
        String this$generalDescription = this.getGeneralDescription();
        String other$generalDescription = other.getGeneralDescription();
        if (this$generalDescription == null ? other$generalDescription != null : !this$generalDescription.equals(other$generalDescription)) {
            return false;
        }
        String this$procedureDescription = this.getProcedureDescription();
        String other$procedureDescription = other.getProcedureDescription();
        if (this$procedureDescription == null ? other$procedureDescription != null : !this$procedureDescription.equals(other$procedureDescription)) {
            return false;
        }
        String this$street = this.getStreet();
        String other$street = other.getStreet();
        if (this$street == null ? other$street != null : !this$street.equals(other$street)) {
            return false;
        }
        String this$streetNo = this.getStreetNo();
        String other$streetNo = other.getStreetNo();
        if (this$streetNo == null ? other$streetNo != null : !this$streetNo.equals(other$streetNo)) {
            return false;
        }
        String this$zipCode = this.getZipCode();
        String other$zipCode = other.getZipCode();
        if (this$zipCode == null ? other$zipCode != null : !this$zipCode.equals(other$zipCode)) {
            return false;
        }
        String this$city = this.getCity();
        String other$city = other.getCity();
        if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
            return false;
        }
        String this$berlinDistrict = this.getBerlinDistrict();
        String other$berlinDistrict = other.getBerlinDistrict();
        if (this$berlinDistrict == null ? other$berlinDistrict != null : !this$berlinDistrict.equals(other$berlinDistrict)) {
            return false;
        }
        LocalDateTime this$startOfWorkPlannedDateTime = this.getStartOfWorkPlannedDateTime();
        LocalDateTime other$startOfWorkPlannedDateTime = other.getStartOfWorkPlannedDateTime();
        if (this$startOfWorkPlannedDateTime == null ? other$startOfWorkPlannedDateTime != null : !((Object)this$startOfWorkPlannedDateTime).equals(other$startOfWorkPlannedDateTime)) {
            return false;
        }
        LocalDateTime this$endOfWorkPlannedDateTime = this.getEndOfWorkPlannedDateTime();
        LocalDateTime other$endOfWorkPlannedDateTime = other.getEndOfWorkPlannedDateTime();
        if (this$endOfWorkPlannedDateTime == null ? other$endOfWorkPlannedDateTime != null : !((Object)this$endOfWorkPlannedDateTime).equals(other$endOfWorkPlannedDateTime)) {
            return false;
        }
        LocalDateTime this$startOfWorkAsIsDateTime = this.getStartOfWorkAsIsDateTime();
        LocalDateTime other$startOfWorkAsIsDateTime = other.getStartOfWorkAsIsDateTime();
        if (this$startOfWorkAsIsDateTime == null ? other$startOfWorkAsIsDateTime != null : !((Object)this$startOfWorkAsIsDateTime).equals(other$startOfWorkAsIsDateTime)) {
            return false;
        }
        LocalDateTime this$endOfWorkAsIsDateTime = this.getEndOfWorkAsIsDateTime();
        LocalDateTime other$endOfWorkAsIsDateTime = other.getEndOfWorkAsIsDateTime();
        if (this$endOfWorkAsIsDateTime == null ? other$endOfWorkAsIsDateTime != null : !((Object)this$endOfWorkAsIsDateTime).equals(other$endOfWorkAsIsDateTime)) {
            return false;
        }
        LocalDateTime this$customDateTime1 = this.getCustomDateTime1();
        LocalDateTime other$customDateTime1 = other.getCustomDateTime1();
        if (this$customDateTime1 == null ? other$customDateTime1 != null : !((Object)this$customDateTime1).equals(other$customDateTime1)) {
            return false;
        }
        LocalDateTime this$customDateTime2 = this.getCustomDateTime2();
        LocalDateTime other$customDateTime2 = other.getCustomDateTime2();
        if (this$customDateTime2 == null ? other$customDateTime2 != null : !((Object)this$customDateTime2).equals(other$customDateTime2)) {
            return false;
        }
        String this$contactPersonOnSite = this.getContactPersonOnSite();
        String other$contactPersonOnSite = other.getContactPersonOnSite();
        if (this$contactPersonOnSite == null ? other$contactPersonOnSite != null : !this$contactPersonOnSite.equals(other$contactPersonOnSite)) {
            return false;
        }
        String this$contactPersonOnSitePhone = this.getContactPersonOnSitePhone();
        String other$contactPersonOnSitePhone = other.getContactPersonOnSitePhone();
        if (this$contactPersonOnSitePhone == null ? other$contactPersonOnSitePhone != null : !this$contactPersonOnSitePhone.equals(other$contactPersonOnSitePhone)) {
            return false;
        }
        String this$contactPersonOnSiteMail = this.getContactPersonOnSiteMail();
        String other$contactPersonOnSiteMail = other.getContactPersonOnSiteMail();
        if (this$contactPersonOnSiteMail == null ? other$contactPersonOnSiteMail != null : !this$contactPersonOnSiteMail.equals(other$contactPersonOnSiteMail)) {
            return false;
        }
        String this$constructionSiteStateName = this.getConstructionSiteStateName();
        String other$constructionSiteStateName = other.getConstructionSiteStateName();
        if (this$constructionSiteStateName == null ? other$constructionSiteStateName != null : !this$constructionSiteStateName.equals(other$constructionSiteStateName)) {
            return false;
        }
        List this$contactPersonIds = this.getContactPersonIds();
        List other$contactPersonIds = other.getContactPersonIds();
        if (this$contactPersonIds == null ? other$contactPersonIds != null : !((Object)this$contactPersonIds).equals(other$contactPersonIds)) {
            return false;
        }
        List this$userAssignedIds = this.getUserAssignedIds();
        List other$userAssignedIds = other.getUserAssignedIds();
        if (this$userAssignedIds == null ? other$userAssignedIds != null : !((Object)this$userAssignedIds).equals(other$userAssignedIds)) {
            return false;
        }
        List this$userInvolvedIds = this.getUserInvolvedIds();
        List other$userInvolvedIds = other.getUserInvolvedIds();
        return !(this$userInvolvedIds == null ? other$userInvolvedIds != null : !((Object)this$userInvolvedIds).equals(other$userInvolvedIds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExtPsxConstructionSiteUpdateRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $executingCompanyId = this.getExecutingCompanyId();
        result = result * 59 + ($executingCompanyId == null ? 43 : ((Object)$executingCompanyId).hashCode());
        Long $releaseOrderId = this.getReleaseOrderId();
        result = result * 59 + ($releaseOrderId == null ? 43 : ((Object)$releaseOrderId).hashCode());
        String $referenceId = this.getReferenceId();
        result = result * 59 + ($referenceId == null ? 43 : $referenceId.hashCode());
        String $projectNumber = this.getProjectNumber();
        result = result * 59 + ($projectNumber == null ? 43 : $projectNumber.hashCode());
        String $generalDescription = this.getGeneralDescription();
        result = result * 59 + ($generalDescription == null ? 43 : $generalDescription.hashCode());
        String $procedureDescription = this.getProcedureDescription();
        result = result * 59 + ($procedureDescription == null ? 43 : $procedureDescription.hashCode());
        String $street = this.getStreet();
        result = result * 59 + ($street == null ? 43 : $street.hashCode());
        String $streetNo = this.getStreetNo();
        result = result * 59 + ($streetNo == null ? 43 : $streetNo.hashCode());
        String $zipCode = this.getZipCode();
        result = result * 59 + ($zipCode == null ? 43 : $zipCode.hashCode());
        String $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : $city.hashCode());
        String $berlinDistrict = this.getBerlinDistrict();
        result = result * 59 + ($berlinDistrict == null ? 43 : $berlinDistrict.hashCode());
        LocalDateTime $startOfWorkPlannedDateTime = this.getStartOfWorkPlannedDateTime();
        result = result * 59 + ($startOfWorkPlannedDateTime == null ? 43 : ((Object)$startOfWorkPlannedDateTime).hashCode());
        LocalDateTime $endOfWorkPlannedDateTime = this.getEndOfWorkPlannedDateTime();
        result = result * 59 + ($endOfWorkPlannedDateTime == null ? 43 : ((Object)$endOfWorkPlannedDateTime).hashCode());
        LocalDateTime $startOfWorkAsIsDateTime = this.getStartOfWorkAsIsDateTime();
        result = result * 59 + ($startOfWorkAsIsDateTime == null ? 43 : ((Object)$startOfWorkAsIsDateTime).hashCode());
        LocalDateTime $endOfWorkAsIsDateTime = this.getEndOfWorkAsIsDateTime();
        result = result * 59 + ($endOfWorkAsIsDateTime == null ? 43 : ((Object)$endOfWorkAsIsDateTime).hashCode());
        LocalDateTime $customDateTime1 = this.getCustomDateTime1();
        result = result * 59 + ($customDateTime1 == null ? 43 : ((Object)$customDateTime1).hashCode());
        LocalDateTime $customDateTime2 = this.getCustomDateTime2();
        result = result * 59 + ($customDateTime2 == null ? 43 : ((Object)$customDateTime2).hashCode());
        String $contactPersonOnSite = this.getContactPersonOnSite();
        result = result * 59 + ($contactPersonOnSite == null ? 43 : $contactPersonOnSite.hashCode());
        String $contactPersonOnSitePhone = this.getContactPersonOnSitePhone();
        result = result * 59 + ($contactPersonOnSitePhone == null ? 43 : $contactPersonOnSitePhone.hashCode());
        String $contactPersonOnSiteMail = this.getContactPersonOnSiteMail();
        result = result * 59 + ($contactPersonOnSiteMail == null ? 43 : $contactPersonOnSiteMail.hashCode());
        String $constructionSiteStateName = this.getConstructionSiteStateName();
        result = result * 59 + ($constructionSiteStateName == null ? 43 : $constructionSiteStateName.hashCode());
        List $contactPersonIds = this.getContactPersonIds();
        result = result * 59 + ($contactPersonIds == null ? 43 : ((Object)$contactPersonIds).hashCode());
        List $userAssignedIds = this.getUserAssignedIds();
        result = result * 59 + ($userAssignedIds == null ? 43 : ((Object)$userAssignedIds).hashCode());
        List $userInvolvedIds = this.getUserInvolvedIds();
        result = result * 59 + ($userInvolvedIds == null ? 43 : ((Object)$userInvolvedIds).hashCode());
        return result;
    }

    public String toString() {
        return "ExtPsxConstructionSiteUpdateRequest(id=" + this.getId() + ", referenceId=" + this.getReferenceId() + ", projectNumber=" + this.getProjectNumber() + ", generalDescription=" + this.getGeneralDescription() + ", procedureDescription=" + this.getProcedureDescription() + ", street=" + this.getStreet() + ", streetNo=" + this.getStreetNo() + ", zipCode=" + this.getZipCode() + ", city=" + this.getCity() + ", berlinDistrict=" + this.getBerlinDistrict() + ", startOfWorkPlannedDateTime=" + String.valueOf(this.getStartOfWorkPlannedDateTime()) + ", endOfWorkPlannedDateTime=" + String.valueOf(this.getEndOfWorkPlannedDateTime()) + ", startOfWorkAsIsDateTime=" + String.valueOf(this.getStartOfWorkAsIsDateTime()) + ", endOfWorkAsIsDateTime=" + String.valueOf(this.getEndOfWorkAsIsDateTime()) + ", customDateTime1=" + String.valueOf(this.getCustomDateTime1()) + ", customDateTime2=" + String.valueOf(this.getCustomDateTime2()) + ", contactPersonOnSite=" + this.getContactPersonOnSite() + ", contactPersonOnSitePhone=" + this.getContactPersonOnSitePhone() + ", contactPersonOnSiteMail=" + this.getContactPersonOnSiteMail() + ", constructionSiteStateName=" + this.getConstructionSiteStateName() + ", executingCompanyId=" + this.getExecutingCompanyId() + ", releaseOrderId=" + this.getReleaseOrderId() + ", contactPersonIds=" + String.valueOf(this.getContactPersonIds()) + ", userAssignedIds=" + String.valueOf(this.getUserAssignedIds()) + ", userInvolvedIds=" + String.valueOf(this.getUserInvolvedIds()) + ")";
    }
}

