/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.helper.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class NullableLocalDateConverter
implements Converter {
    private static final DateTimeFormatter GAEB_DATE_ISO = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter();

    public void marshal(Object o, HierarchicalStreamWriter writer, MarshallingContext context) {
        if (o instanceof LocalDate) {
            LocalDate localDate = (LocalDate)o;
            writer.setValue(GAEB_DATE_ISO.format(localDate));
        }
    }

    public LocalDate unmarshal(@NonNull HierarchicalStreamReader reader, @NonNull UnmarshallingContext context) {
        if (reader == null) {
            throw new NullPointerException("reader is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        String value = StringUtils.trimToEmpty((String)reader.getValue());
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return LocalDate.from(GAEB_DATE_ISO.parse(value));
        }
        return null;
    }

    public boolean canConvert(Class cls) {
        return cls == LocalDate.class;
    }
}

