/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.helper.comparator.quotation;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import de.qfm.erp.service.helper.comparator.quotation.QuotationPositionComparator;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class QuotationPositionSequentialNumberComparator
extends QuotationPositionComparator {
    private static final Logger log = LogManager.getLogger(QuotationPositionSequentialNumberComparator.class);

    public int compare(@NonNull QuotationPosition left, @NonNull QuotationPosition right) {
        Quotation rightStage;
        long addendumNumberRight;
        if (left == null) {
            throw new NullPointerException("left is marked non-null but is null");
        }
        if (right == null) {
            throw new NullPointerException("right is marked non-null but is null");
        }
        Quotation leftStage = left.getQuotation();
        long addendumNumberLeft = null != leftStage ? (Long)MoreObjects.firstNonNull((Object)leftStage.getAddendumNumber(), (Object)0L) : -1L;
        int i = Longs.compare((long)addendumNumberLeft, (long)(addendumNumberRight = null != (rightStage = right.getQuotation()) ? (Long)MoreObjects.firstNonNull((Object)rightStage.getAddendumNumber(), (Object)0L) : -1L));
        if (i != 0) {
            return i;
        }
        Integer leftSN = (Integer)MoreObjects.firstNonNull((Object)left.getSequenceNumberQuotationStandard(), (Object)0);
        Integer rightSN = (Integer)MoreObjects.firstNonNull((Object)right.getSequenceNumberQuotationStandard(), (Object)0);
        i = Ints.compare((int)leftSN, (int)rightSN);
        return i;
    }

    public QuotationPositionComparator from(@NonNull Quotation quotation) {
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        return this;
    }

    private QuotationPositionSequentialNumberComparator() {
    }

    public static QuotationPositionSequentialNumberComparator of() {
        return new QuotationPositionSequentialNumberComparator();
    }
}

