/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.helper.comparator;

import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import de.qfm.erp.service.model.internal.employee.payroll.WageTypeCalculationResult;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollItemType;
import java.util.Comparator;
import javax.annotation.Nonnull;

public class WageTypeCalculationResultComparator
implements Comparator<WageTypeCalculationResult> {
    @Nonnull
    public static final WageTypeCalculationResultComparator INSTANCE = new WageTypeCalculationResultComparator();

    @Override
    public int compare(WageTypeCalculationResult l, WageTypeCalculationResult r) {
        PayrollItemType payrollItemTypeL = l.getPayrollItemType();
        PayrollItemType payrollItemTypeR = r.getPayrollItemType();
        Integer leftPITOrder = payrollItemTypeL.getSequentialNumber();
        Integer rightPITOrder = payrollItemTypeR.getSequentialNumber();
        int compare1st = Ordering.natural().nullsLast().compare((Object)leftPITOrder, (Object)rightPITOrder);
        if (compare1st != 0) {
            return compare1st;
        }
        return Ints.compare((int)l.getOrder(), (int)r.getOrder());
    }

    private WageTypeCalculationResultComparator() {
    }
}

