/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.helper.comparator;

import de.qfm.erp.service.model.internal.businessunit.BusinessUnitTree;
import de.qfm.erp.service.model.jpa.businessunit.BusinessUnit;
import java.util.Comparator;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class BusinessUnitComparator
implements Comparator<BusinessUnitTree> {
    public static final BusinessUnitComparator BUSINESS_UNIT_COMPARATOR = new BusinessUnitComparator();

    @Override
    public int compare(@NonNull BusinessUnitTree left, @NonNull BusinessUnitTree right) {
        if (left == null) {
            throw new NullPointerException("left is marked non-null but is null");
        }
        if (right == null) {
            throw new NullPointerException("right is marked non-null but is null");
        }
        BusinessUnit leftBusinessUnit = left.getBusinessUnit();
        BusinessUnit rightBusinessUnit = right.getBusinessUnit();
        int compare = StringUtils.compareIgnoreCase((String)leftBusinessUnit.getCostCenter(), (String)rightBusinessUnit.getCostCenter());
        if (compare == 0) {
            compare = StringUtils.compareIgnoreCase((String)leftBusinessUnit.getShortName(), (String)rightBusinessUnit.getShortName());
        }
        if (compare == 0) {
            compare = StringUtils.compareIgnoreCase((String)leftBusinessUnit.getLongName(), (String)rightBusinessUnit.getLongName());
        }
        return compare;
    }
}

