/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.helper;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.qfm.erp.service.helper.comparator.quotation.QuotationPositionSequentialNumberComparator;
import de.qfm.erp.service.model.internal.invoice.AddendumDiscount;
import de.qfm.erp.service.model.internal.quotation.QEntityTreeStatistics;
import de.qfm.erp.service.model.internal.quotation.StagePositionGroup;
import de.qfm.erp.service.model.jpa.quotation.EQStageState;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import de.qfm.erp.service.model.jpa.shared.EPositionType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class QuotationHelper {
    public static final String GROUPING_INGORE_CHARS = "*";

    public static boolean isQuotationEnded(@NonNull Quotation quotation) {
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        Boolean flagOrderEnd = quotation.getFlagOrderEnd();
        return Objects.equals(flagOrderEnd, Boolean.TRUE);
    }

    public static boolean isStageEnded(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        EQStageState stageState = stage.getStageState();
        return EQStageState.ARCHIVED == stageState;
    }

    public static boolean isQuotationCommissionNumberPresentAndNeeded(@NonNull Quotation quotation) {
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        Boolean flagMeasurementWithoutCommissionNumberAllowed = quotation.getFlagMeasurementWithoutCommissionNumberAllowed();
        return Objects.equals(flagMeasurementWithoutCommissionNumberAllowed, Boolean.FALSE);
    }

    public static boolean isNotAllowedToWriteMeasurement(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        return !QuotationHelper.isAllowedToWriteMeasurement((Quotation)stage);
    }

    public static boolean isAllowedToWriteMeasurement(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        EQStageType stageType = stage.getStageType();
        EQStageState stageState = stage.getStageState();
        if (stageType == EQStageType.COMMISSION && Iterables.contains((Iterable)EQStageState.ACCOUNTABLE_STAGE_STATES, (Object)stageState)) {
            return true;
        }
        if (Iterables.contains((Iterable)EQStageType.ADDENDUM_TYPES, (Object)stageType) && Iterables.contains((Iterable)EQStageState.ACCOUNTABLE_STAGE_STATES, (Object)stageState)) {
            return true;
        }
        if (Iterables.contains((Iterable)EQStageType.ADDENDUM_TYPES, (Object)stageType) && ImmutableSet.of((Object)EQStageState.SUBMITTED).contains((Object)stageState) && stage.getFlagMeasurementWithoutCommissionNumberAllowed().booleanValue()) {
            return true;
        }
        if ((stageType == EQStageType.COMMISSION__COST_UNIT || stageType == EQStageType.COMMISSION__COST_UNIT__CE) && (Iterables.contains((Iterable)EQStageState.ACCOUNTABLE_STAGE_STATES, (Object)stageState) || Iterables.contains((Iterable)EQStageState.ADDITIONAL_MEASUREMENT_STAGE_STATES, (Object)stageState))) {
            return true;
        }
        return stageType == EQStageType.QUOTATION && ImmutableSet.of((Object)EQStageState.SUBMITTED, (Object)EQStageState.DESIGNATED_COMMISSION).contains((Object)stageState) && stage.getFlagMeasurementWithoutCommissionNumberAllowed() != false;
    }

    @Nonnull
    public static BigDecimal discount(@NonNull AddendumDiscount quotationDiscount) {
        if (quotationDiscount == null) {
            throw new NullPointerException("quotationDiscount is marked non-null but is null");
        }
        BigDecimal generalDiscount = (BigDecimal)MoreObjects.firstNonNull((Object)quotationDiscount.getGeneralDiscount(), (Object)BigDecimal.ZERO);
        BigDecimal otherDiscount = (BigDecimal)MoreObjects.firstNonNull((Object)quotationDiscount.getOtherDiscount(), (Object)BigDecimal.ZERO);
        return generalDiscount.add(otherDiscount);
    }

    @Nonnull
    public static String stageName(@NonNull QEntityTreeStatistics quotation) {
        String versionString;
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        String alias = quotation.getStageAlias();
        String qNumber = quotation.getStageQNumber();
        String quotationNumber = quotation.getStageQuotationNumber();
        Integer version = quotation.getVersion();
        String string = versionString = null != version ? String.format("[Ver. %s]", version) : "";
        return StringUtils.isNotBlank((CharSequence)alias) ? alias + versionString : (StringUtils.isNotBlank((CharSequence)qNumber) ? qNumber + versionString : quotationNumber + versionString);
    }

    @Nonnull
    public static String stageName(@NonNull Quotation quotation) {
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        String alias = quotation.getAlias();
        String qNumber = quotation.getQNumber();
        String quotationNumber = quotation.getQuotationNumber();
        return StringUtils.isNotBlank((CharSequence)alias) ? alias : (StringUtils.isNotBlank((CharSequence)qNumber) ? qNumber : quotationNumber);
    }

    @Nonnull
    public static Iterable<StagePositionGroup> positionGroups(@NonNull Quotation stage, boolean generateStructureFromRemark, boolean flatten) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        EQStageType stageType = stage.getStageType();
        boolean keepPositionChild = stageType == EQStageType.COMMISSION__COST_ESTIMATE;
        return QuotationHelper.positionGroups((Quotation)stage, (boolean)generateStructureFromRemark, (boolean)flatten, (boolean)keepPositionChild);
    }

    @Nonnull
    public static Iterable<StagePositionGroup> positionGroups(@NonNull Quotation stage, boolean generateStructureFromRemark, boolean flatten, boolean keepPositionChild) {
        String parentKey;
        StagePositionGroup positionGroup;
        String key;
        Object positionType;
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        LinkedHashMap positionInGroups = Maps.newLinkedHashMap();
        Set positions = (Set)MoreObjects.firstNonNull((Object)stage.getQuotationPositions(), (Object)ImmutableSet.of());
        Set positionsFiltered = positions.stream().filter(item -> keepPositionChild || !Iterables.contains((Iterable)EPositionType.JUMBO_CHILD, (Object)item.getPositionType())).collect(Collectors.toSet());
        ImmutableList positionsSorted = ImmutableList.sortedCopyOf((Comparator)QuotationPositionSequentialNumberComparator.of(), positionsFiltered);
        Long maxId = positionsFiltered.stream().map(QuotationPosition::getId).max(Long::compareTo).orElse(0L);
        AtomicLong fallbackId = new AtomicLong(1L + maxId);
        for (QuotationPosition quotationPosition : positionsSorted) {
            positionType = quotationPosition.getPositionType();
            if (EPositionType.COMMENT != positionType || positionInGroups.containsKey(key = QuotationHelper.groupKey((QuotationPosition)quotationPosition))) continue;
            positionGroup = StagePositionGroup.natural();
            positionGroup.setId(quotationPosition.getId());
            positionGroup.setKey(key);
            positionGroup.setShortText(StringUtils.trimToEmpty((String)quotationPosition.getShortText()));
            positionGroup.setLongText(StringUtils.trimToEmpty((String)quotationPosition.getLongText()));
            positionInGroups.put(key, positionGroup);
        }
        for (QuotationPosition quotationPosition : positionsSorted) {
            positionType = quotationPosition.getPositionType();
            if (!generateStructureFromRemark && !Iterables.contains((Iterable)EPositionType.GROUPING_POSITION_TYPES, (Object)positionType)) continue;
            String parentKey2 = QuotationHelper.groupKey((QuotationPosition)quotationPosition);
            do {
                if (positionInGroups.containsKey(parentKey2)) continue;
                positionGroup = StagePositionGroup.generated();
                positionGroup.setId(Long.valueOf(fallbackId.getAndIncrement()));
                positionGroup.setKey(parentKey2);
                positionGroup.setShortText(StringUtils.trimToEmpty((String)quotationPosition.getShortText()));
                positionGroup.setLongText(StringUtils.trimToEmpty((String)quotationPosition.getLongText()));
                positionInGroups.put(parentKey2, positionGroup);
            } while (StringUtils.isNotBlank((CharSequence)(parentKey2 = QuotationHelper.parentKey((String)parentKey2))));
        }
        for (Map.Entry entry : positionInGroups.entrySet()) {
            String key2 = (String)entry.getKey();
            StagePositionGroup value = (StagePositionGroup)entry.getValue();
            parentKey = QuotationHelper.parentKey((String)key2);
            StagePositionGroup parent = (StagePositionGroup)positionInGroups.get(parentKey);
            if (null == parent || value == parent) continue;
            parent.getChildren().put(key2, value);
        }
        for (QuotationPosition quotationPosition : positionsSorted) {
            positionType = quotationPosition.getPositionType();
            key = QuotationHelper.groupKey((QuotationPosition)quotationPosition);
            parentKey = QuotationHelper.parentKey((QuotationPosition)quotationPosition);
            boolean root = positionType == EPositionType.COMMENT && StringUtils.isBlank((CharSequence)parentKey);
            if (root || positionType != EPositionType.COMMENT || StringUtils.equals((CharSequence)key, (CharSequence)parentKey)) continue;
            StagePositionGroup current = (StagePositionGroup)positionInGroups.get(key);
            if (positionInGroups.containsKey(parentKey)) {
                StagePositionGroup parent = (StagePositionGroup)positionInGroups.get(parentKey);
                Map children = parent.getChildren();
                children.put(current.getKey(), current);
                continue;
            }
            throw new IllegalArgumentException("Should never Happen:" + parentKey);
        }
        for (QuotationPosition quotationPosition : positionsSorted) {
            positionType = quotationPosition.getPositionType();
            if (positionType == EPositionType.COMMENT) {
                key = QuotationHelper.groupKey((QuotationPosition)quotationPosition);
                if (positionInGroups.containsKey(key)) {
                    positionGroup = (StagePositionGroup)positionInGroups.get(key);
                    positionGroup.getComments().add(quotationPosition);
                    continue;
                }
                positionGroup = StagePositionGroup.generated();
                positionGroup.setId(quotationPosition.getId());
                positionGroup.setKey(key);
                positionGroup.setShortText(StringUtils.trimToEmpty((String)quotationPosition.getShortText()));
                positionGroup.setLongText(StringUtils.trimToEmpty((String)quotationPosition.getLongText()));
                positionInGroups.put(key, positionGroup);
                continue;
            }
            if (!Iterables.contains((Iterable)EPositionType.GROUPING_CHILDREN_POSITION_TYPES, (Object)positionType)) continue;
            key = QuotationHelper.standardKeys((QuotationPosition)quotationPosition);
            if (positionInGroups.containsKey(key)) {
                positionGroup = (StagePositionGroup)positionInGroups.get(key);
                positionGroup.getPositions().add(quotationPosition);
                continue;
            }
            if (!generateStructureFromRemark) continue;
            throw new IllegalArgumentException("Should never Happen as we defined already all possible Groups for key: " + key);
        }
        TreeSet allKeys = Sets.newTreeSet(positionInGroups.keySet());
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
        for (String s : allKeys) {
            positionGroup = (StagePositionGroup)positionInGroups.get(s);
            Map children = (Map)MoreObjects.firstNonNull((Object)positionGroup.getChildren(), (Object)ImmutableMap.of());
            linkedHashSet.addAll(children.keySet());
        }
        ImmutableList.Builder positionGroupsSorted = ImmutableList.builder();
        for (String currentKey : allKeys) {
            if (!flatten && linkedHashSet.contains(currentKey)) continue;
            positionGroupsSorted.add((Object)((StagePositionGroup)positionInGroups.get(currentKey)));
        }
        return positionGroupsSorted.build();
    }

    @Nonnull
    @VisibleForTesting
    static String groupKey(@NonNull QuotationPosition position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        String g1 = position.getGroupingElementLevel1();
        String g2 = position.getGroupingElementLevel2();
        String g3 = position.getGroupingElementLevel3();
        String g4 = position.getGroupingElementLevel4();
        ArrayList currentKey = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)g4) && !StringUtils.equalsAny((CharSequence)g4, (CharSequence[])new CharSequence[]{"*"})) {
            currentKey.add(g1);
            currentKey.add(g2);
            currentKey.add(g3);
            currentKey.add(g4);
        } else if (StringUtils.isNotBlank((CharSequence)g3) && !StringUtils.equalsAny((CharSequence)g3, (CharSequence[])new CharSequence[]{"*"})) {
            currentKey.add(g1);
            currentKey.add(g2);
            currentKey.add(g3);
        } else if (StringUtils.isNotBlank((CharSequence)g2) && !StringUtils.equalsAny((CharSequence)g2, (CharSequence[])new CharSequence[]{"*"})) {
            currentKey.add(g1);
            currentKey.add(g2);
        } else if (StringUtils.isNotBlank((CharSequence)g1) && !StringUtils.equalsAny((CharSequence)g1, (CharSequence[])new CharSequence[]{"*"})) {
            currentKey.add(g1);
        }
        return Joiner.on((char)'.').join((Iterable)currentKey);
    }

    @Nonnull
    @VisibleForTesting
    static String parentKey(@NonNull QuotationPosition position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        String g1 = position.getGroupingElementLevel1();
        String g2 = position.getGroupingElementLevel2();
        String g3 = position.getGroupingElementLevel3();
        String g4 = position.getGroupingElementLevel4();
        EPositionType positionType = position.getPositionType();
        ArrayList currentKey = Lists.newArrayList();
        if (positionType == EPositionType.COMMENT) {
            if (StringUtils.isNotBlank((CharSequence)g1) && !StringUtils.equalsAny((CharSequence)g1, (CharSequence[])new CharSequence[]{"*"})) {
                currentKey.add(g1);
            }
            if (StringUtils.isNotBlank((CharSequence)g2) && !StringUtils.equalsAny((CharSequence)g2, (CharSequence[])new CharSequence[]{"*"})) {
                currentKey.add(g2);
            }
            if (StringUtils.isNotBlank((CharSequence)g3) && !StringUtils.equalsAny((CharSequence)g3, (CharSequence[])new CharSequence[]{"*"})) {
                currentKey.add(g3);
            }
            if (StringUtils.isNotBlank((CharSequence)g4) && !StringUtils.equalsAny((CharSequence)g4, (CharSequence[])new CharSequence[]{"*"})) {
                currentKey.add(g4);
            }
            if (!currentKey.isEmpty()) {
                currentKey.remove(currentKey.size() - 1);
            }
        } else if (Iterables.contains((Iterable)EPositionType.PRINTABLE_POSITIONS, (Object)positionType)) {
            if (StringUtils.isNotBlank((CharSequence)g1)) {
                currentKey.add(g1);
            }
            if (StringUtils.isNotBlank((CharSequence)g2)) {
                currentKey.add(g2);
            }
            if (StringUtils.isNotBlank((CharSequence)g3)) {
                currentKey.add(g3);
            }
            if (StringUtils.isNotBlank((CharSequence)g4)) {
                currentKey.add(g4);
            }
        }
        return Joiner.on((char)'.').join((Iterable)currentKey);
    }

    @Nonnull
    @VisibleForTesting
    static String parentKey(@NonNull String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (input.contains(".")) {
            return StringUtils.substringBeforeLast((String)input, (String)".");
        }
        return "";
    }

    @Nonnull
    @VisibleForTesting
    static String standardKeys(@NonNull QuotationPosition position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        String g1 = position.getGroupingElementLevel1();
        String g2 = position.getGroupingElementLevel2();
        String g3 = position.getGroupingElementLevel3();
        String g4 = position.getGroupingElementLevel4();
        EPositionType positionType = position.getPositionType();
        ArrayList currentKey = Lists.newArrayList();
        if (Iterables.contains((Iterable)EPositionType.PRINTABLE_POSITIONS, (Object)positionType)) {
            if (StringUtils.isNotBlank((CharSequence)g4)) {
                currentKey.add(g1);
                currentKey.add(g2);
                currentKey.add(g3);
                currentKey.add(g4);
            } else if (StringUtils.isNotBlank((CharSequence)g3)) {
                currentKey.add(g1);
                currentKey.add(g2);
                currentKey.add(g3);
            } else if (StringUtils.isNotBlank((CharSequence)g2)) {
                currentKey.add(g1);
                currentKey.add(g2);
            } else if (StringUtils.isNotBlank((CharSequence)g1)) {
                currentKey.add(g1);
            }
        }
        return Joiner.on((char)'.').join((Iterable)currentKey);
    }
}

