/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.helper;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Streams;
import de.qfm.erp.service.model.jpa.quotation.EQStageState;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import de.qfm.erp.service.model.jpa.quotation.QEntity;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.NonNull;

/*
 * Exception performing whole class analysis ignored.
 */
public class QEntityHelper {
    @Nonnull
    @VisibleForTesting
    public static Long determineAvailableAddendumNumber(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        EQStageType stageType = stage.getStageType();
        if (Iterables.contains((Iterable)EQStageType.ZERO_ADDENDUM_NUMBER, (Object)stageType)) {
            return 0L;
        }
        QEntity qEntity = stage.getQEntity();
        return QEntityHelper.determineAvailableAddendumNumber((QEntity)qEntity);
    }

    @Nonnull
    @VisibleForTesting
    public static Long determineAvailableAddendumNumber(@NonNull QEntity entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        Multimap existingAddendumNumbers = QEntityHelper.existingAddendumNumbers((QEntity)entity, (Iterable)ImmutableSet.of());
        Set existingAddendumNumberLongs = existingAddendumNumbers.keySet();
        Long currentMax = Streams.stream((Iterable)existingAddendumNumberLongs).max(Long::compareTo).orElse(0L);
        return 1L + currentMax;
    }

    @Nonnull
    @VisibleForTesting
    public static Multimap<Long, Quotation> existingAddendumNumbers(@NonNull Quotation stage, @NonNull Iterable<Quotation> ignoreStage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        if (ignoreStage == null) {
            throw new NullPointerException("ignoreStage is marked non-null but is null");
        }
        QEntity qEntity = stage.getQEntity();
        Integer currentVersion = stage.getVersion();
        Multimap unfiltered = QEntityHelper.existingAddendumNumbers((QEntity)qEntity, ignoreStage);
        return Multimaps.filterValues((Multimap)unfiltered, item -> Objects.equals(item.getVersion(), currentVersion));
    }

    @Nonnull
    @VisibleForTesting
    public static Multimap<Long, Quotation> existingAddendumNumbers(@NonNull QEntity entity, @NonNull Iterable<Quotation> ignoreStage) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (ignoreStage == null) {
            throw new NullPointerException("ignoreStage is marked non-null but is null");
        }
        Set stages = (Set)MoreObjects.firstNonNull((Object)entity.getStages(), (Object)ImmutableSet.of());
        return (Multimap)stages.stream().filter(item -> null != item.getAddendumNumber() && item.getAddendumNumber() > 0L).filter(item -> EQStageState.TEMPORARY != item.getStageState()).filter(item -> EQStageState.ARCHIVED != item.getStageState()).filter(item -> !Iterables.contains((Iterable)ignoreStage, (Object)item)).filter(item -> Iterables.contains((Iterable)EQStageType.ADDENDUM_TYPES, (Object)item.getStageType())).collect(Multimaps.toMultimap(Quotation::getAddendumNumber, item -> item, ArrayListMultimap::create));
    }
}

