/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.helper;

import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.model.internal.pdfbox.EBooleanPrintOption;
import de.qfm.erp.service.model.internal.print.qentity.EStagePrintFeature;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public final class PrintOptionHelper {
    @NonNull
    public static Iterable<EBooleanPrintOption> measurementPrintOptions(@NonNull Map<String, String> allRequestParams) {
        if (allRequestParams == null) {
            throw new NullPointerException("allRequestParams is marked non-null but is null");
        }
        ImmutableSet.Builder printOptionBuilder = ImmutableSet.builder();
        for (EBooleanPrintOption printOption : EBooleanPrintOption.values()) {
            String parameter = printOption.getParameter();
            String value = allRequestParams.get(parameter);
            if (null == value && printOption.isDefaultValue()) {
                printOptionBuilder.add((Object)printOption);
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)Boolean.TRUE.toString())) continue;
            printOptionBuilder.add((Object)printOption);
        }
        return printOptionBuilder.build();
    }

    @NonNull
    public static Iterable<EStagePrintFeature> stagePrintOptions(@NonNull Map<String, String> allRequestParams) {
        if (allRequestParams == null) {
            throw new NullPointerException("allRequestParams is marked non-null but is null");
        }
        ImmutableSet.Builder printOptionBuilder = ImmutableSet.builder();
        for (EStagePrintFeature printOption : EStagePrintFeature.values()) {
            String parameter = printOption.getParameter();
            String value = allRequestParams.get(parameter);
            if (null == value && printOption.isDefaultValue()) {
                printOptionBuilder.add((Object)printOption);
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)Boolean.TRUE.toString())) continue;
            printOptionBuilder.add((Object)printOption);
        }
        return printOptionBuilder.build();
    }
}

