/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.helper;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.qfm.erp.common.request.employee.payroll.PayrollItemModificationItem;
import de.qfm.erp.common.request.employee.payroll.PayrollMonthUpdateRequest;
import de.qfm.erp.service.helper.MapsHelper;
import de.qfm.erp.service.helper.PayrollMonthHelper;
import de.qfm.erp.service.model.internal.employee.QuotationWageDetail;
import de.qfm.erp.service.model.internal.employee.StageWage;
import de.qfm.erp.service.model.internal.employee.payroll.AggPaidWage;
import de.qfm.erp.service.model.internal.measurement.AggMeasurementWage;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonthItem;
import de.qfm.erp.service.model.jpa.user.User;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class PayrollMonthHelper {
    @Nonnull
    public static Iterable<String> incentiveQuotationNumbers(@NonNull PayrollMonthUpdateRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Iterable incentiveUpdateItems = (Iterable)MoreObjects.firstNonNull((Object)request.getIncentivePayrollItems(), (Object)ImmutableList.of());
        return (Iterable)Streams.stream((Iterable)incentiveUpdateItems).map(PayrollItemModificationItem::getQuotationNumber).filter(StringUtils::isNotBlank).collect(ImmutableSet.toImmutableSet());
    }

    @Nonnull
    public static Function<User, Boolean> usersInReleasedStateFn(@NonNull YearMonth accountingMonth, @NonNull Iterable<Attendance> attendances, @NonNull Iterable<PayrollMonthItem> payrollMonthItems, @NonNull BiFunction<Iterable<User>, YearMonth, Iterable<PayrollMonth>> fn) {
        if (accountingMonth == null) {
            throw new NullPointerException("accountingMonth is marked non-null but is null");
        }
        if (attendances == null) {
            throw new NullPointerException("attendances is marked non-null but is null");
        }
        if (payrollMonthItems == null) {
            throw new NullPointerException("payrollMonthItems is marked non-null but is null");
        }
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        if (!Iterables.isEmpty(payrollMonthItems) || !Iterables.isEmpty(attendances)) {
            ImmutableSet usersToValidateReleasedStateA = (ImmutableSet)Streams.stream(attendances).map(Attendance::getSquadLeader).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
            ImmutableSet usersToValidateReleasedStateB = (ImmutableSet)Streams.stream(payrollMonthItems).map(PayrollMonthItem::getRecipient).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
            ImmutableSet usersToValidateReleasedState = ImmutableSet.copyOf((Collection)Sets.union((Set)usersToValidateReleasedStateA, (Set)usersToValidateReleasedStateB));
            return PayrollMonthHelper.usersInReleasedStateFn((YearMonth)accountingMonth, (Iterable)usersToValidateReleasedState, fn);
        }
        return item -> false;
    }

    @Nonnull
    public static Function<User, Boolean> usersInReleasedStateFn(@NonNull YearMonth accountingMonth, @NonNull Iterable<User> usersToValidateReleasedState, @NonNull BiFunction<Iterable<User>, YearMonth, Iterable<PayrollMonth>> fn) {
        if (accountingMonth == null) {
            throw new NullPointerException("accountingMonth is marked non-null but is null");
        }
        if (usersToValidateReleasedState == null) {
            throw new NullPointerException("usersToValidateReleasedState is marked non-null but is null");
        }
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        if (!Iterables.isEmpty(usersToValidateReleasedState)) {
            Iterable<PayrollMonth> payrollMonthsInReleasedState = fn.apply(usersToValidateReleasedState, accountingMonth);
            ImmutableSet userIdsWithPayrollMonthInReleasedState = (ImmutableSet)Streams.stream(payrollMonthsInReleasedState).map(PayrollMonth::getUser).filter(Objects::nonNull).map(User::getId).collect(ImmutableSet.toImmutableSet());
            return item -> null != item && userIdsWithPayrollMonthInReleasedState.contains((Object)item.getId());
        }
        return item -> false;
    }

    @Nonnull
    public static Iterable<StageWage> stageWages(@NonNull LocalDate accountingMonth, @NonNull Iterable<AggMeasurementWage> availableWages, @NonNull Iterable<AggPaidWage> paidWages, boolean hideZero, @NonNull Long filterSelfPayrollMonthId) {
        if (accountingMonth == null) {
            throw new NullPointerException("accountingMonth is marked non-null but is null");
        }
        if (availableWages == null) {
            throw new NullPointerException("availableWages is marked non-null but is null");
        }
        if (paidWages == null) {
            throw new NullPointerException("paidWages is marked non-null but is null");
        }
        if (filterSelfPayrollMonthId == null) {
            throw new NullPointerException("filterSelfPayrollMonthId is marked non-null but is null");
        }
        Multimap availableByQuotation = MapsHelper.map(availableWages, AggMeasurementWage::getQuotationNumber, item -> item);
        Multimap paidByQuotation = MapsHelper.map(paidWages, AggPaidWage::getQuotationNumber, item -> item);
        LinkedHashMap allStageDataByQNo = Maps.newLinkedHashMap();
        availableByQuotation.forEach((k, v) -> {
            Long stageId = v.getStageId();
            String stageNumber = v.getStageNumber();
            String stageAlias = v.getStageAlias();
            Integer version = v.getStageVersion();
            String projectName = v.getProjectName();
            String projectReferenceId = v.getProjectReferenceId();
            if (!allStageDataByQNo.containsKey(k) || StringUtils.isBlank((CharSequence)((StageData)allStageDataByQNo.get(k)).getStageNumber())) {
                allStageDataByQNo.put(k, StageData.of((String)k, (Long)stageId, (Integer)version, (String)stageNumber, (String)stageAlias, (String)projectName, (String)projectReferenceId));
            }
        });
        paidByQuotation.forEach((k, v) -> {
            Long stageId = v.getStageId();
            String stageNumber = v.getStageNumber();
            String stageAlias = v.getStageAlias();
            Integer version = v.getStageVersion();
            String projectName = v.getProjectName();
            String projectReferenceId = v.getProjectReferenceId();
            if (!allStageDataByQNo.containsKey(k) || StringUtils.isBlank((CharSequence)((StageData)allStageDataByQNo.get(k)).getStageNumber())) {
                allStageDataByQNo.put(k, StageData.of((String)k, (Long)stageId, (Integer)version, (String)stageNumber, (String)stageAlias, (String)projectName, (String)projectReferenceId));
            }
        });
        ImmutableList.Builder quotationWageBuilder = ImmutableList.builder();
        for (String quotationNumber : allStageDataByQNo.keySet()) {
            BigDecimal wageAvailableOverallSumNormalized;
            StageData stageData = (StageData)allStageDataByQNo.get(quotationNumber);
            Collection measurementWagesForQuotation = availableByQuotation.get((Object)quotationNumber);
            Collection paidWagesForQuotation = paidByQuotation.get((Object)quotationNumber);
            Collection paidWagesForQuotationWithoutAccountingMonth = (Collection)paidWagesForQuotation.stream().filter(item -> PayrollMonthHelper.differentDate((LocalDate)item.getAccountingMonth(), (LocalDate)accountingMonth)).collect(ImmutableList.toImmutableList());
            Collection paidWagesForQuotationWithoutPayrollMonth = (Collection)paidWagesForQuotation.stream().filter(item -> !Objects.equals(item.getPayrollMonthId(), filterSelfPayrollMonthId)).collect(ImmutableList.toImmutableList());
            Collection paidWagesForQuotationWithoutFuture = (Collection)paidWagesForQuotation.stream().filter(item -> !accountingMonth.isBefore(item.getAccountingMonth())).collect(ImmutableList.toImmutableList());
            boolean hasFuturePayments = paidWagesForQuotation.stream().anyMatch(item -> accountingMonth.isBefore(item.getAccountingMonth()));
            BigDecimal measurementWagesSum = measurementWagesForQuotation.stream().map(AggMeasurementWage::getSquadWageOverall).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal paidWagesSum = paidWagesForQuotation.stream().map(AggPaidWage::getValue).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal paidWagesWithoutFutureSum = paidWagesForQuotationWithoutFuture.stream().map(AggPaidWage::getValue).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal paidWagesWithoutAccountingMonthSum = paidWagesForQuotationWithoutAccountingMonth.stream().map(AggPaidWage::getValue).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal paidWagesWithoutPayrollMonthSum = paidWagesForQuotationWithoutPayrollMonth.stream().map(AggPaidWage::getValue).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal wageAvailableOverallSum = measurementWagesSum.subtract(paidWagesSum);
            BigDecimal wageAvailableOverallWithoutFutureSum = measurementWagesSum.subtract(paidWagesWithoutFutureSum);
            BigDecimal wageAvailableOverallWithoutAccountingMonthSum = measurementWagesSum.subtract(paidWagesWithoutAccountingMonthSum);
            BigDecimal wageAvailableOverallWithoutPayrollMonthSum = measurementWagesSum.subtract(paidWagesWithoutPayrollMonthSum);
            BigDecimal bigDecimal = wageAvailableOverallSumNormalized = hasFuturePayments ? wageAvailableOverallSum.max(BigDecimal.ZERO) : wageAvailableOverallSum;
            if (hideZero && wageAvailableOverallWithoutPayrollMonthSum.compareTo(BigDecimal.ZERO) == 0) continue;
            Long stageId = (Long)MoreObjects.firstNonNull((Object)stageData.getStageId(), (Object)0L);
            Integer stageVersion = stageData.getVersion();
            String stageNumber = stageData.getStageNumber();
            String stageAlias = stageData.getStageAlias();
            String projectName = stageData.getProjectName();
            String projectReferenceId = stageData.getProjectReferenceId();
            Iterable quotationWageDetails = (Iterable)measurementWagesForQuotation.stream().map(item -> QuotationWageDetail.of((String)item.getMeasurementNumber(), (LocalDate)item.getAccountingMonth(), (BigDecimal)item.getSquadWageOverall())).collect(ImmutableList.toImmutableList());
            quotationWageBuilder.add((Object)StageWage.of((String)quotationNumber, (Long)stageId, (String)stageNumber, (String)stageAlias, (Integer)stageVersion, (String)projectName, (String)projectReferenceId, (boolean)hasFuturePayments, (BigDecimal)measurementWagesSum, (BigDecimal)paidWagesSum, (BigDecimal)wageAvailableOverallSumNormalized, (BigDecimal)wageAvailableOverallWithoutAccountingMonthSum, (BigDecimal)wageAvailableOverallWithoutPayrollMonthSum, (BigDecimal)wageAvailableOverallWithoutPayrollMonthSum, (BigDecimal)wageAvailableOverallWithoutFutureSum, (Iterable)quotationWageDetails));
        }
        return quotationWageBuilder.build();
    }

    private static boolean differentDate(@NonNull LocalDate left, @NonNull LocalDate right) {
        if (left == null) {
            throw new NullPointerException("left is marked non-null but is null");
        }
        if (right == null) {
            throw new NullPointerException("right is marked non-null but is null");
        }
        return !PayrollMonthHelper.sameDate((LocalDate)left, (LocalDate)right);
    }

    private static boolean sameDate(@NonNull LocalDate left, @NonNull LocalDate right) {
        if (left == null) {
            throw new NullPointerException("left is marked non-null but is null");
        }
        if (right == null) {
            throw new NullPointerException("right is marked non-null but is null");
        }
        return left.isEqual(right);
    }
}

