/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.helper;

import com.google.common.base.MoreObjects;
import jakarta.persistence.Converter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;

/*
 * Exception performing whole class analysis ignored.
 */
@Converter
public class DurationHelper {
    @Nonnull
    public static String asTimeWithoutSeconds(@Nullable Duration duration, boolean nullsAsZero) {
        if (null == duration && !nullsAsZero) {
            return "";
        }
        return DurationHelper.asTimeWithoutSeconds((Duration)((Duration)MoreObjects.firstNonNull((Object)duration, (Object)Duration.ZERO)));
    }

    @Nonnull
    public static String asTimeWithoutSeconds(@NonNull Duration duration) {
        if (duration == null) {
            throw new NullPointerException("duration is marked non-null but is null");
        }
        long seconds = duration.getSeconds();
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        return String.format("%d:%02d", hours, minutes);
    }

    @Nullable
    public static Duration zeroToNull(@Nullable Duration duration) {
        return null == duration || Duration.ZERO == duration ? null : duration;
    }

    @Nonnull
    public static BigDecimal hours(@NonNull Duration duration) {
        if (duration == null) {
            throw new NullPointerException("duration is marked non-null but is null");
        }
        BigDecimal minutes = BigDecimal.valueOf(duration.toMinutes()).setScale(2, RoundingMode.HALF_UP);
        return minutes.divide(BigDecimal.valueOf(60L), 2, RoundingMode.HALF_UP);
    }

    @Nonnull
    public static Duration hours(@NonNull BigDecimal value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        BigDecimal multiply = value.multiply(BigDecimal.valueOf(60L));
        return Duration.ofMinutes(multiply.longValue());
    }
}

