/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.helper;

import com.google.common.collect.ImmutableList;
import de.qfm.erp.service.model.internal.quotation.BidderComplement;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class BidderComplementHelper {
    private static final String OPEN = "{{";
    private static final String CLOSE = "}}";
    private static final String SEPARATOR = "|";
    public static final String LINE_SEPARATOR = "\n";

    @Nonnull
    public static Iterable<BidderComplement> bidderComplements(@NonNull String bidderComplement) {
        if (bidderComplement == null) {
            throw new NullPointerException("bidderComplement is marked non-null but is null");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        String[] bidderKeys = StringUtils.substringsBetween((String)bidderComplement, (String)"{{", (String)"}}");
        if (null != bidderKeys) {
            for (int i = 0; i < bidderKeys.length; ++i) {
                String bidderKeyCurrent = bidderKeys[i];
                String bidderKeyId = StringUtils.trimToEmpty((String)StringUtils.substringBefore((String)bidderKeyCurrent, (String)"|"));
                String bidderKeyType = StringUtils.trimToEmpty((String)StringUtils.substringAfter((String)bidderKeyCurrent, (String)"|"));
                BidderComplement.EBidderComplementType bidderComplementType = BidderComplementHelper.type((String)bidderKeyType);
                if (i < bidderKeys.length - 1) {
                    String bidderKeyNext = bidderKeys[1 + i];
                    String content = StringUtils.trimToEmpty((String)StringUtils.substringBetween((String)bidderComplement, (String)(bidderKeyCurrent + "}}"), (String)("{{" + bidderKeyNext))) + "\n";
                    builder.add((Object)BidderComplement.of((String)bidderKeyId, (BidderComplement.EBidderComplementType)bidderComplementType, (String)content));
                    continue;
                }
                String content = StringUtils.trimToEmpty((String)StringUtils.substringAfterLast((String)bidderComplement, (String)(bidderKeyCurrent + "}}")));
                builder.add((Object)BidderComplement.of((String)bidderKeyId, (BidderComplement.EBidderComplementType)bidderComplementType, (String)content));
            }
        }
        return builder.build();
    }

    @Nonnull
    private static BidderComplement.EBidderComplementType type(@NonNull String bidderKeyType) {
        if (bidderKeyType == null) {
            throw new NullPointerException("bidderKeyType is marked non-null but is null");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)bidderKeyType, (CharSequence)BidderComplement.EBidderComplementType.BIDDER.name())) {
            return BidderComplement.EBidderComplementType.BIDDER;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)bidderKeyType, (CharSequence)BidderComplement.EBidderComplementType.OWNER.name())) {
            return BidderComplement.EBidderComplementType.OWNER;
        }
        return BidderComplement.EBidderComplementType.UNKNOWN;
    }

    @Nonnull
    public static String bidderComplementPlaceHolder(@NonNull String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return "{{" + input + "}}";
    }
}

