/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.configuration.search;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.ControlledRealTimeReopenThread;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.SearcherManager;
import org.springframework.context.annotation.Configuration;

@Configuration
public class LuceneRealTimeThreadConfiguration {
    private static final Logger log = LogManager.getLogger(LuceneRealTimeThreadConfiguration.class);
    private final IndexWriter indexWriter;
    private final SearcherManager searcherManager;
    private final IndexWriter spellcheckWriter;
    private final SearcherManager searcherSpellcheckManager;
    private ControlledRealTimeReopenThread<IndexSearcher> NRT_SEARCH_THREAD;
    private ControlledRealTimeReopenThread<IndexSearcher> NRT_SPELLCHECK_THREAD;

    @PostConstruct
    private void postConstruct() throws IOException {
        this.NRT_SEARCH_THREAD = new ControlledRealTimeReopenThread(this.indexWriter, (ReferenceManager)this.searcherManager, 1.0, 0.1);
        this.NRT_SEARCH_THREAD.setName("NRT Search Thread");
        this.NRT_SEARCH_THREAD.setPriority(Math.min(Thread.currentThread().getPriority() + 2, 10));
        this.NRT_SEARCH_THREAD.setDaemon(true);
        this.NRT_SEARCH_THREAD.start();
        this.NRT_SPELLCHECK_THREAD = new ControlledRealTimeReopenThread(this.spellcheckWriter, (ReferenceManager)this.searcherSpellcheckManager, 1.0, 0.1);
        this.NRT_SPELLCHECK_THREAD.setName("Spellcheck Search Thread");
        this.NRT_SPELLCHECK_THREAD.setPriority(Math.min(Thread.currentThread().getPriority() + 2, 10));
        this.NRT_SPELLCHECK_THREAD.setDaemon(true);
        this.NRT_SPELLCHECK_THREAD.start();
    }

    @PreDestroy
    public void destroy() {
        Stream.of(this.NRT_SEARCH_THREAD, this.NRT_SPELLCHECK_THREAD).filter(Objects::nonNull).filter(item -> !item.isInterrupted()).forEach(Thread::interrupt);
    }

    public LuceneRealTimeThreadConfiguration(IndexWriter indexWriter, SearcherManager searcherManager, IndexWriter spellcheckWriter, SearcherManager searcherSpellcheckManager) {
        this.indexWriter = indexWriter;
        this.searcherManager = searcherManager;
        this.spellcheckWriter = spellcheckWriter;
        this.searcherSpellcheckManager = searcherSpellcheckManager;
    }
}

